<?php 
$pageTitle = "Validasi Soal";
require_once __DIR__ . '/../layouts/wakur_header.php';
?>

<div class="alert alert-info">
    <i class="bi bi-info-circle-fill me-2"></i>
    Halaman ini menyimulasikan proses validasi. AI akan menganalisis kesesuaian soal dengan mata pelajaran.
</div>

<!-- Prototipe AI Analysis -->
<div id="ai-analysis-step" class="text-center p-4 card">
    <h5><i class="bi bi-robot"></i> Menganalisis Kesesuaian Soal...</h5>
    <p class="text-muted">AI sedang memeriksa relevansi soal "Matematika" yang baru ditambahkan. Mohon tunggu.</p>
    <div class="progress mt-3" style="height: 20px;">
        <div id="ai-progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar" style="width: 0%"></div>
    </div>
</div>

<!-- Hasil Tinjauan (Hidden by default) -->
<div id="review-step" style="display: none;">
    <div class="card">
        <div class="card-body">
            <div class="alert alert-success">
                <h5 class="alert-heading">Hasil Analisis AI</h5>
                <p>AI merekomendasikan untuk <strong>Menyetujui</strong> kumpulan soal ini dengan tingkat kesesuaian rata-rata <strong>95%</strong> terhadap mata pelajaran Matematika.</p>
            </div>
            
            <h5 class="mt-4">Tindakan Validasi</h5>
            <p>Setujui atau tolak semua 15 soal yang menunggu untuk mata pelajaran ini.</p>
            <div class="d-flex justify-content-end gap-2">
                <button class="btn btn-danger" onclick="alert('Semua soal ditolak (prototipe).')">Tolak Semua</button>
                <button class="btn btn-success" onclick="alert('Semua soal disetujui (prototipe).')">Setujui Semua</button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const analysisStep = document.getElementById('ai-analysis-step');
    const reviewStep = document.getElementById('review-step');
    const progressBar = document.getElementById('ai-progress-bar');
    
    let progress = 0;
    const interval = setInterval(() => {
        progress += Math.floor(Math.random() * 10) + 10;
        if (progress > 100) progress = 100;
        progressBar.style.width = progress + '%';
        progressBar.textContent = progress + '%';
        
        if (progress === 100) {
            clearInterval(interval);
            setTimeout(() => {
                analysisStep.style.display = 'none';
                reviewStep.style.display = 'block';
            }, 500);
        }
    }, 400);
});
</script>

<?php require_once __DIR__ . '/../layouts/wakur_footer.php'; ?>