<?php 
$pageTitle = "Validasi Soal per Mata Pelajaran";
require_once __DIR__ . '/../layouts/wakur_header.php';
require_once __DIR__ . '/../../models/Wakur.php';

$model = new Wakur();
$mapelPending = $model->getMapelWithPendingSoal();
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <h4 class="mb-3">Pilih Mata Pelajaran untuk Divalidasi</h4>

        <?php
        if (isset($_SESSION['flash_message'])) {
            $message = $_SESSION['flash_message'];
            echo '<div class="alert alert-' . htmlspecialchars($message['type']) . '" role="alert">' . $message['text'] . '</div>';
            unset($_SESSION['flash_message']);
        }
        ?>

        <div class="list-group">
            <?php if (empty($mapelPending)): ?>
                <div class="list-group-item text-center text-muted">Tidak ada soal yang perlu divalidasi saat ini.</div>
            <?php else: ?>
                <?php foreach ($mapelPending as $mapel): ?>
                    <a href="tinjau_soal.php?mapel_id=<?= $mapel['mapel_id'] ?>" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1"><?= htmlspecialchars($mapel['nama_pelajaran']) ?></h5>
                            <span class="badge bg-warning text-dark rounded-pill"><?= $mapel['jumlah_pending'] ?> Soal Menunggu</span>
                        </div>
                        <p class="mb-1">Klik untuk meninjau dan melakukan validasi soal untuk mata pelajaran ini.</p>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/wakur_footer.php'; ?>