<?php 
$mapelId = $_GET['mapel_id'] ?? null;
if (!$mapelId) die("Mata pelajaran tidak valid.");

// Tambahkan ini untuk mendapatkan informasi mapel
require_once __DIR__ . '/../../models/MataPelajaran.php'; 
$mapelModel = new MataPelajaran();
$mapelInfo = $mapelModel->getById($mapelId);

$pageTitle = "Tinjau Soal: " . htmlspecialchars($mapelInfo['nama_pelajaran'] ?? '...');
require_once __DIR__ . '/../layouts/wakur_header.php';
require_once __DIR__ . '/../../models/Wakur.php';

$wakurModel = new Wakur();
$soalList = $wakurModel->getPendingSoalByMapel($mapelId);
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex align-items-center mb-3">
            <a href="validasi_mapel.php" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Tinjau Soal: <?= htmlspecialchars($mapelInfo['nama_pelajaran'] ?? 'Unknown') ?></h4>
        </div>
        <hr>

        <div id="ai-analysis-step" class="text-center p-4">
            <h5><i class="bi bi-robot"></i> Menganalisis Kesesuaian Soal...</h5>
            <p class="text-muted">AI sedang memeriksa relevansi setiap soal terhadap mata pelajaran. Mohon tunggu.</p>
            <div class="progress mt-3" style="height: 20px;">
                <div id="ai-progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar" style="width: 0%"></div>
            </div>
        </div>

        <div id="review-step" style="display: none;">
            <div class="alert alert-info">
                <h5 class="alert-heading">Hasil Analisis AI</h5>
                <p>AI merekomendasikan untuk <strong>Menyetujui</strong> kumpulan soal ini dengan tingkat kesesuaian rata-rata <strong>92%</strong> terhadap mata pelajaran <?= htmlspecialchars($mapelInfo['nama_pelajaran'] ?? '') ?>.</p>
            </div>
            
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>No</th>
                            <th>Pertanyaan</th>
                            <th>Jenis</th>
                            <th>Skor Relevansi AI</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($soalList)): ?>
                            <tr><td colspan="4" class="text-center">Tidak ada soal untuk divalidasi.</td></tr>
                        <?php else: ?>
                            <?php foreach($soalList as $index => $soal): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($soal['pertanyaan']) ?></td>
                                <td><?= htmlspecialchars($soal['jenis_soal']) ?></td>
                                <td>
                                    <?php $skor = rand(85, 99); // Skor relevansi acak untuk prototipe ?>
                                    <span class="badge bg-<?= $skor > 90 ? 'success' : 'warning' ?>"><?= $skor ?>% Relevan</span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <hr>
            <h5 class="mt-4">Tindakan Validasi</h5>
            <p>Setujui atau tolak semua soal yang menunggu untuk mata pelajaran ini secara bersamaan.</p>
            <form action="<?= BASE_URL ?>/wakur.php?action=proses_validasi_mapel" method="POST">
                <input type="hidden" name="mapel_id" value="<?= $mapelId ?>">
                <div class="mb-3">
                    <label for="catatan_validasi" class="form-label">Catatan Validasi</label>
                    <textarea class="form-control" name="catatan_validasi" rows="3" placeholder="Berikan catatan jika diperlukan (wajib jika menolak)."></textarea>
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <button type="submit" name="status" value="Ditolak" class="btn btn-danger">Tolak Semua</button>
                    <button type="submit" name="status" value="Disetujui" class="btn btn-success">Setujui Semua</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const analysisStep = document.getElementById('ai-analysis-step');
    const reviewStep = document.getElementById('review-step');
    const progressBar = document.getElementById('ai-progress-bar');
    
    let progress = 0;
    const interval = setInterval(() => {
        progress += Math.floor(Math.random() * 10) + 10;
        if (progress > 100) progress = 100;
        
        progressBar.style.width = progress + '%';
        progressBar.textContent = progress + '%';
        
        if (progress === 100) {
            clearInterval(interval);
            setTimeout(() => {
                analysisStep.style.display = 'none';
                reviewStep.style.display = 'block';
            }, 500); // Jeda singkat setelah selesai
        }
    }, 400); // Kecepatan simulasi
});
</script>

<?php require_once __DIR__ . '/../layouts/wakur_footer.php'; ?>