<?php 
$pageTitle = "Laporan Akademik";
require_once __DIR__ . '/../layouts/wakur_header.php';
require_once __DIR__ . '/../../models/Wakur.php';

$model = new Wakur();
$laporan = $model->getLaporanUjian();
?>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="card-title mb-0"><i class="bi bi-file-earmark-bar-graph-fill me-2"></i>Rekapitulasi Hasil Ujian Keseluruhan</h5>
            <button class="btn btn-success" onclick="alert('Fitur unduh laporan sedang dalam pengembangan.')">
                <i class="bi bi-download me-2"></i>Unduh Laporan (XLS)
            </button>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>No</th>
                        <th>Nama Ujian</th>
                        <th>Mata Pelajaran</th>
                        <th>Jumlah Peserta</th>
                        <th>Skor Rata-rata</th>
                        <th>Tanggal Dibuat</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($laporan)): ?>
                        <tr><td colspan="6" class="text-center text-muted">Belum ada data ujian untuk ditampilkan.</td></tr>
                    <?php else: ?>
                        <?php foreach ($laporan as $index => $item): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($item['judul_ujian']) ?></td>
                                <td><?= htmlspecialchars($item['nama_pelajaran']) ?></td>
                                <td><?= $item['jumlah_peserta'] ?> Siswa</td>
                                <td>
                                    <?php
                                        $skor = $item['rata_rata_skor'];
                                        if ($skor === null) {
                                            echo '<span class="badge bg-secondary">N/A</span>';
                                        } else {
                                            $badgeClass = $skor >= 75 ? 'bg-success' : 'bg-warning text-dark';
                                            echo '<span class="badge ' . $badgeClass . '">' . number_format($skor, 2) . '</span>';
                                        }
                                    ?>
                                </td>
                                <td><?= date('d M Y', strtotime($item['created_at'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/wakur_footer.php'; ?>