<?php 
$pageTitle = "Capaian Pembelajaran";
require_once __DIR__ . '/../layouts/wakur_header.php';
?>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="card-title mb-0">Daftar Capaian Pembelajaran</h5>
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#cpModal"><i class="bi bi-plus-circle me-2"></i>Tambah CP Baru</button>
        </div>
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Mata Pelajaran</th>
                    <th>Fase</th>
                    <th>Deskripsi</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>CP-001</td>
                    <td>Matematika</td>
                    <td>Fase E</td>
                    <td>Siswa mampu menyelesaikan masalah kontekstual persamaan...</td>
                    <td>
                        <button class="btn btn-sm btn-warning"><i class="bi bi-pencil-fill"></i></button>
                        <button class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></button>
                    </td>
                </tr>
                <tr>
                    <td>CP-002</td>
                    <td>Fotografi Dasar</td>
                    <td>Fase E</td>
                    <td>Siswa mampu memahami dan menerapkan konsep segitiga eksposur...</td>
                    <td>
                        <button class="btn btn-sm btn-warning"><i class="bi bi-pencil-fill"></i></button>
                        <button class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal untuk Tambah/Edit CP -->
<div class="modal fade" id="cpModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Form Capaian Pembelajaran</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form>
            <div class="mb-3"><label class="form-label">Mata Pelajaran</label><select class="form-select"><option>Matematika</option><option>Fotografi Dasar</option></select></div>
            <div class="mb-3"><label class="form-label">Fase</label><input type="text" class="form-control" value="Fase E"></div>
            <div class="mb-3"><label class="form-label">Deskripsi</label><textarea class="form-control" rows="4"></textarea></div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <button type="button" class="btn btn-success" onclick="alert('Data CP (prototipe) berhasil disimpan!')">Simpan</button>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../layouts/wakur_footer.php'; ?>