<?php
$pageTitle = "Pengerjaan Ujian";
require_once __DIR__ . '/../layouts/main_header_siswa.php';
require_once __DIR__ . '/../../models/UjianSiswa.php';
require_once __DIR__ . '/../../models/User.php';

$ujianId = $_GET['ujian_id'] ?? null;
if (!$ujianId) die("ID Ujian tidak valid.");

$userModel = new User();
$siswaData = $userModel->findSiswaByUserId($_SESSION['user_id']);
if (!$siswaData) die("Data siswa tidak ditemukan.");
$siswaId = $siswaData['siswa_id'];

$ujianModel = new UjianSiswa();
$soalList = $ujianModel->getExamDetails($ujianId);
if (empty($soalList)) die("Soal untuk ujian ini tidak ditemukan.");

$soalJson = json_encode($soalList);
?>

<div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><?= htmlspecialchars($soalList[0]['judul_ujian']); ?></h5>
        <div class="fw-bold"><i class="bi bi-stopwatch"></i> <span id="timer">01:30:00</span></div>
    </div>
    <div class="card-body">
        <div id="soal-container"></div>
        <hr>
        <div class="d-flex justify-content-between mt-4">
            <button id="prev-btn" class="btn btn-secondary" disabled><i class="bi bi-arrow-left"></i> Sebelumnya</button>
            <div id="question-nav" class="d-flex align-items-center">Soal <span id="current-q" class="mx-2 fw-bold">1</span> dari <span id="total-q" class="fw-bold"><?= count($soalList) ?></span></div>
            <button id="next-btn" class="btn btn-primary">Berikutnya <i class="bi bi-arrow-right"></i></button>
            <button id="finish-btn" class="btn btn-success" style="display: none;">Kumpulkan Jawaban <i class="bi bi-check-circle"></i></button>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const soalList = JSON.parse('<?= addslashes($soalJson) ?>');
    const totalSoal = soalList.length;
    let currentSoalIndex = 0;
    const jawabanSiswa = {};

    const soalContainer = document.getElementById('soal-container');
    const currentQEl = document.getElementById('current-q');
    const prevBtn = document.getElementById('prev-btn');
    const nextBtn = document.getElementById('next-btn');
    const finishBtn = document.getElementById('finish-btn');

    function renderSoal(index) {
        const soal = soalList[index];
        let html = `<div class="mb-3"><strong>Pertanyaan:</strong><p class="fs-5 mt-2">${soal.pertanyaan}</p></div>`;

        if (soal.jenis_soal === 'Pilihan Ganda') {
            const options = soal.opsi;
            html += '<div class="list-group">';
            options.forEach(opt => {
                const isChecked = jawabanSiswa[soal.soal_id] === opt ? 'checked' : '';
                html += `<label class="list-group-item list-group-item-action">
                            <input class="form-check-input me-2" type="radio" name="opsi" value="${opt.replace(/"/g, '&quot;')}" ${isChecked}>
                            ${opt}
                         </label>`;
            });
            html += '</div>';
        } else {
            const jawaban = jawabanSiswa[soal.soal_id] || '';
            html += `<textarea class="form-control" rows="8" placeholder="Ketik jawaban Anda di sini...">${jawaban}</textarea>`;
        }
        soalContainer.innerHTML = html;
        updateNavButtons();
    }

    function simpanJawaban() {
        const soal = soalList[currentSoalIndex];
        if (soal.jenis_soal === 'Pilihan Ganda') {
            const selected = document.querySelector('input[name="opsi"]:checked');
            jawabanSiswa[soal.soal_id] = selected ? selected.value : null;
        } else {
            jawabanSiswa[soal.soal_id] = soalContainer.querySelector('textarea').value;
        }
    }

    function updateNavButtons() {
        currentQEl.textContent = currentSoalIndex + 1;
        prevBtn.disabled = currentSoalIndex === 0;
        nextBtn.style.display = currentSoalIndex === totalSoal - 1 ? 'none' : 'inline-block';
        finishBtn.style.display = currentSoalIndex === totalSoal - 1 ? 'inline-block' : 'none';
    }
    
    prevBtn.addEventListener('click', () => { simpanJawaban(); if (currentSoalIndex > 0) { currentSoalIndex--; renderSoal(currentSoalIndex); } });
    nextBtn.addEventListener('click', () => { simpanJawaban(); if (currentSoalIndex < totalSoal - 1) { currentSoalIndex++; renderSoal(currentSoalIndex); } });
    
    finishBtn.addEventListener('click', async () => {
        simpanJawaban();
        if (confirm('Apakah Anda yakin ingin mengumpulkan jawaban? Aksi ini tidak dapat dibatalkan.')) {
            try {
                const payload = {
                    ujian_id: <?= $ujianId ?>,
                    siswa_id: <?= $siswaId ?>,
                    answers: jawabanSiswa
                };
                const response = await fetch('<?= BASE_URL ?>/api/submit-ujian', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(payload)
                });
                const result = await response.json();
                if (!response.ok) throw new Error(result.message);
                alert(result.message);
                window.location.href = result.redirect_url;
            } catch (error) {
                alert('Terjadi kesalahan: ' + error.message);
            }
        }
    });

    renderSoal(currentSoalIndex);
});
</script>