<?php
$pageTitle = "Hasil Ujian";
require_once __DIR__ . '/../layouts/main_header_siswa.php';
require_once __DIR__ . '/../../models/UjianSiswa.php';

$hasilId = $_GET['hasil_id'] ?? null;
if (!$hasilId) die("ID Hasil Ujian tidak valid.");

$ujianModel = new UjianSiswa();
$hasil = $ujianModel->getExamResult($hasilId);
if (!$hasil) die("Data hasil ujian tidak ditemukan.");

$ujianId = $hasil['ujian_id'];
$soalList = $ujianModel->getExamDetails($ujianId);
$jawabanSiswa = json_decode($hasil['jawaban_siswa'], true);
?>

<div class="card shadow-sm">
    <div class="card-header bg-success text-white">
        <h4 class="mb-0">Hasil Ujian: <?= htmlspecialchars($hasil['judul_ujian']); ?></h4>
    </div>
    <div class="card-body p-4">
        <div class="row border-bottom pb-3 mb-3">
            <div class="col-md-8">
                <p class="mb-1"><strong>Nama Siswa:</strong> <?= htmlspecialchars($hasil['nama_siswa']); ?></p>
                <p class="mb-0"><strong>Waktu Selesai:</strong> <?= date('d F Y, H:i', strtotime($hasil['created_at'])); ?> WIB</p>
            </div>
            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                <p class="mb-1">SKOR AKHIR</p>
                <h1 class="display-4 fw-bold text-success mb-0"><?= number_format($hasil['skor_akhir'], 2); ?></h1>
            </div>
        </div>

        <div class="alert alert-info mt-4">
            <h5 class="alert-heading"><i class="bi bi-robot"></i> Feedback dari AI</h5>
            <p class="mb-0" style="white-space: pre-wrap;"><?= htmlspecialchars($hasil['feedback_ai']); ?></p>
        </div>

        <h5 class="mt-4">Detail Jawaban Anda</h5>
        <hr>
        <?php foreach ($soalList as $index => $soal): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <strong>Soal #<?= $index + 1 ?></strong>
                </div>
                <div class="card-body">
                    <p><?= htmlspecialchars($soal['pertanyaan']); ?></p>
                    
                    <?php 
                    $jawabanUser = $jawabanSiswa[$soal['soal_id']] ?? '<i class="text-muted">Tidak dijawab</i>';
                    $isCorrect = ($soal['jawaban_benar'] === $jawabanUser);
                    ?>

                    <?php if ($soal['jenis_soal'] == 'Pilihan Ganda'): ?>
                        <p class="mb-1">Jawaban Anda: 
                            <span class="fw-bold <?= $isCorrect ? 'text-success' : 'text-danger'; ?>">
                                <?= htmlspecialchars($jawabanUser); ?>
                                <?= $isCorrect ? '<i class="bi bi-check-circle-fill ms-1"></i>' : '<i class="bi bi-x-circle-fill ms-1"></i>'; ?>
                            </span>
                        </p>
                        <?php if (!$isCorrect): ?>
                            <p class="mb-0 text-success">Jawaban Benar: <?= htmlspecialchars($soal['jawaban_benar']); ?></p>
                        <?php endif; ?>
                    <?php else: ?>
                        <h6>Jawaban Anda:</h6>
                        <p class="p-2 bg-light border rounded"><?= nl2br(htmlspecialchars($jawabanUser)); ?></p>
                        <h6>Kunci Jawaban:</h6>
                        <p class="p-2 bg-light border rounded"><?= htmlspecialchars($soal['jawaban_benar']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>

        <div class="text-center mt-4">
            <a href="<?= BASE_URL ?>/dashboard-siswa" class="btn btn-primary btn-lg">
                <i class="bi bi-arrow-left-circle"></i> Kembali ke Dashboard
            </a>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>