<?php 
$pageTitle = "Dashboard Siswa";
require_once __DIR__ . '/../layouts/main_header_siswa.php';
require_once __DIR__ . '/../../models/UjianSiswa.php';
require_once __DIR__ . '/../../models/User.php';

$userModel = new User();
$siswaData = $userModel->findSiswaByUserId($_SESSION['user_id']);
if (!$siswaData) die("Data siswa tidak ditemukan.");
$siswaId = $siswaData['siswa_id'];

$ujianModel = new UjianSiswa();
$daftarUjianTersedia = $ujianModel->getAvailableExamsForSiswa($siswaId);
$riwayatUjian = $ujianModel->getExamHistory($siswaId);
?>

<section class="mb-4">
    <h1 class="h3">Halo, <?= htmlspecialchars($_SESSION['user_name']); ?>!</h1>
    <p>Selamat datang! Silakan pilih ujian yang tersedia atau lihat riwayat ujian Anda.</p>
</section>

<section class="mb-5">
    <h5 class="mb-3">Ujian yang Tersedia</h5>
    <div class="list-group">
        <?php if (empty($daftarUjianTersedia)): ?>
            <div class="list-group-item text-center text-muted">Tidak ada ujian baru yang tersedia saat ini.</div>
        <?php else: ?>
            <?php foreach ($daftarUjianTersedia as $ujian): ?>
                <a href="<?= BASE_URL ?>/kerjakan-ujian?ujian_id=<?= $ujian['ujian_id']; ?>" class="list-group-item list-group-item-action">
                    <div class="d-flex w-100 justify-content-between">
                        <h5 class="mb-1"><?= htmlspecialchars($ujian['judul_ujian']); ?></h5>
                        <small>Kode: <?= htmlspecialchars($ujian['kode_ujian']); ?></small>
                    </div>
                    <p class="mb-1">Mata Pelajaran: <?= htmlspecialchars($ujian['nama_pelajaran']); ?></p>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</section>

<section>
    <h5 class="mb-3">Riwayat Ujian Anda</h5>
    <div class="list-group">
        <?php if (empty($riwayatUjian)): ?>
            <div class="list-group-item text-center text-muted">Anda belum pernah mengerjakan ujian.</div>
        <?php else: ?>
            <?php foreach ($riwayatUjian as $riwayat): ?>
                <a href="<?= BASE_URL ?>/hasil-ujian?hasil_id=<?= $riwayat['hasil_id']; ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1"><?= htmlspecialchars($riwayat['judul_ujian']); ?></h6>
                        <small class="text-muted">Dikerjakan pada: <?= date('d M Y, H:i', strtotime($riwayat['created_at'])); ?> WIB</small>
                    </div>
                    <span class="badge bg-primary rounded-pill fs-6">Skor: <?= number_format($riwayat['skor_akhir'], 2); ?></span>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</section>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>