<?php
// session_start() sudah dipanggil di config.php
if (!defined('BASE_URL')) {
    require_once __DIR__ . '/../../config.php';
}

// Proteksi Halaman
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'wakil kurikulum') {
    // PERBAIKAN: Redirect ke rute, bukan file
    header('Location: ' . BASE_URL . '/login-wakur');
    exit();
}

// PERBAIKAN: Mendapatkan rute saat ini dari URL untuk menandai link aktif
$currentRoute = $_GET['url'] ?? 'dashboard-wakur';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Waka Kurikulum'; ?> - Sistem Ujian Otomatis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/wakur_style.css">
</head>
<body>

<nav class="sidebar">
    <div class="sidebar-sticky">
        <div class="text-center my-3">
            <img src="<?= BASE_URL ?>/assets/images/logo.png" alt="Logo" width="60">
            <h5 class="text-white mt-2">SMK Tritech</h5>
        </div>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= ($currentRoute == 'dashboard-wakur') ? 'active' : '' ?>" href="<?= BASE_URL ?>/dashboard-wakur">
                    <i class="bi bi-grid-1x2-fill"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= ($currentRoute == 'capaian-pembelajaran') ? 'active' : '' ?>" href="<?= BASE_URL ?>/capaian-pembelajaran">
                    <i class="bi bi-bullseye"></i> Capaian Pembelajaran
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= ($currentRoute == 'validasi-mapel' || $currentRoute == 'tinjau-soal') ? 'active' : '' ?>" href="<?= BASE_URL ?>/validasi-mapel">
                    <i class="bi bi-check2-square"></i> Validasi Soal
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= ($currentRoute == 'laporan') ? 'active' : '' ?>" href="<?= BASE_URL ?>/laporan">
                    <i class="bi bi-file-earmark-bar-graph-fill"></i> Laporan
                </a>
            </li>
        </ul>
        <div class="mt-auto p-3">
             <a href="<?= BASE_URL ?>/logout" class="btn btn-danger w-100">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </div>
    </div>
</nav>

<main class="main-content">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2"><?= $pageTitle ?? 'Dashboard' ?></h1>
        <div class="btn-toolbar mb-2 mb-md-0">
            <div class="btn-group me-2">
                <span class="btn btn-sm btn-outline-secondary">Selamat Datang, <?= htmlspecialchars($_SESSION['user_name']); ?>!</span>
            </div>
        </div>
    </div>