<?php
session_start();
require_once __DIR__ . '/../../config/config.php';

// Proteksi Halaman: Cek apakah user sudah login dan memiliki role wakil kurikulum
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'wakil kurikulum') {
    header('Location: ' . BASE_URL . '/views/auth/login_wakur.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Waka Kurikulum'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="<?= BASE_URL; ?>/assets/css/dashboard_style.css">
</head>
<body>
    <header class="navbar navbar-expand-lg navbar-light bg-light sticky-top shadow-sm">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="#">
                <img src="<?= BASE_URL; ?>/assets/images/logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-text-top me-2">
                Portal Waka Kurikulum
            </a>
            <a href="<?= BASE_URL; ?>/auth.php?action=logout" class="btn btn-outline-danger btn-sm">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </div>
    </header>

    <main class="container my-4">