<?php
// session_start() sudah dipanggil di config.php
if (!defined('BASE_URL')) {
    require_once __DIR__ . '/../../config.php';
}

// Proteksi Halaman
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'guru') {
    // PERBAIKAN: Redirect ke rute, bukan file
    header('Location: ' . BASE_URL . '/login-guru');
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Dashboard'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/dashboard_style.css">
</head>
<body>
    <header class="navbar navbar-expand-lg navbar-light bg-light sticky-top shadow-sm">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="<?= BASE_URL ?>/dashboard-guru">
                <img src="<?= BASE_URL ?>/assets/images/logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-text-top me-2">
                Dashboard Guru
            </a>
            <a href="<?= BASE_URL ?>/logout" class="btn btn-outline-danger btn-sm">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </div>
    </header>
    <main class="container my-4">