<?php 
$pageTitle = "Unggah Materi Baru";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/MataPelajaran.php';

$mapelModel = new MataPelajaran();
$daftarMapel = $mapelModel->getAll();
?>

<div class="card shadow-sm">
    <div class="card-body p-4">

        <div id="loading-overlay" style="display: none;">
            <div class="spinner-border text-primary" role="status"></div>
            <p id="loading-text" class="mt-3">Memproses...</p>
        </div>

        <div id="upload-section">
            <div class="d-flex align-items-center mb-3">
                <a href="dashboard.php" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
                <h4 class="m-0">Unggah Materi Baru</h4>
            </div>
            <hr>
            
            <div class="row mb-3">
                <div class="col-md-6 mb-3 mb-md-0">
                    <label for="mapel_id" class="form-label">Mata Pelajaran</label>
                    <select class="form-select" id="mapel_id" name="mapel_id" required>
                        <option value="" disabled selected>-- Pilih Mata Pelajaran --</option>
                        <?php foreach ($daftarMapel as $mapel): ?>
                            <option value="<?= $mapel['mapel_id']; ?>"><?= htmlspecialchars($mapel['nama_pelajaran']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="judul" class="form-label">Judul Materi</label>
                    <input type="text" class="form-control" id="judul" name="judul" required placeholder="Contoh: Latihan Soal Aljabar">
                </div>
            </div>

            <ul class="nav nav-tabs nav-fill mb-3" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="camera-tab" data-bs-toggle="tab" data-bs-target="#camera-content" type="button" role="tab"><i class="bi bi-camera-fill me-2"></i>Ambil dari Kamera</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="upload-tab" data-bs-toggle="tab" data-bs-target="#upload-content" type="button" role="tab"><i class="bi bi-file-earmark-arrow-up-fill me-2"></i>Unggah Berkas</button>
                </li>
            </ul>

            <div class="tab-content p-3 border border-top-0 rounded-bottom" id="myTabContent">
                <div class="tab-pane fade show active" id="camera-content" role="tabpanel">
                    <p class="text-muted text-center">Gambar materi berhasil diambil. Klik tombol di bawah untuk memproses.</p>
                    <div class="camera-wrapper mb-3">
                        <img src="<?= BASE_URL ?>/assets/images/soalmm.jpg" alt="Gambar Soal Matematika" style="width: 100%; height: 100%; object-fit: contain;">
                    </div>
                    <div class="d-grid">
                        <button id="process-camera-btn" class="btn btn-primary">Proses & Ringkas Materi</button>
                    </div>
                </div>
                <div class="tab-pane fade" id="upload-content" role="tabpanel">
                    <form id="upload-form">
                        <div class="mb-3">
                            <label for="file_materi" class="form-label">Pilih Berkas (JPG, PNG, PDF, DOCX)</label>
                            <input class="form-control" type="file" id="file_materi" name="file_materi" accept="image/jpeg, image/png, application/pdf, application/vnd.openxmlformats-officedocument.wordprocessingml.document" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Proses & Ringkas Materi</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div id="result-section" style="display: none;">
            <h4 class="mb-3">Hasil Proses Otomatis</h4>
            <hr>
            <div class="mb-3">
                <label class="form-label fw-bold">Ringkasan Materi:</label>
                <textarea id="summary-output" class="form-control" rows="8" readonly></textarea>
            </div>
            <div class="card bg-light mb-4">
                <div class="card-body">
                    <h5 class="card-title">Buat Soal Otomatis</h5>
                    <div class="row align-items-end">
                        <div class="col-md-8">
                            <label for="question-type" class="form-label">Pilih Jenis Soal</label>
                            <select id="question-type" class="form-select">
                                <option value="pilihan_ganda">Pilihan Ganda</option>
                                <option value="esai">Esai</option>
                            </select>
                        </div>
                        <div class="col-md-4 d-grid">
                            <button id="generate-questions-btn" class="btn btn-info text-white">Buat Soal</button>
                        </div>
                    </div>
                </div>
            </div>
            <div id="questions-output-container" style="display: none;">
                <h5 class="fw-bold">Tinjau Soal</h5>
                <div id="questions-output" class="mb-3"></div>
                <div class="d-grid">
                    <button id="save-all-btn" class="btn btn-success btn-lg">Simpan Materi & Soal ke Bank Soal</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const materiData = { mapel_id: null, judul: null, ringkasan: null, soal: [] };
    const loadingOverlay = document.getElementById('loading-overlay');
    const loadingText = document.getElementById('loading-text');
    const uploadSection = document.getElementById('upload-section');
    const resultSection = document.getElementById('result-section');

    // DATA DUMMY MATEMATIKA (ALJABAR)
    const mathSummary = "Materi ini mencakup penyederhanaan ekspresi aljabar linear. Konsep utamanya adalah mengelompokkan suku-suku sejenis, yaitu suku-suku yang memiliki variabel dan pangkat yang sama. Contohnya, suku dengan variabel 'x' hanya bisa dijumlahkan atau dikurangkan dengan suku lain yang juga memiliki variabel 'x'. Konstanta (angka tanpa variabel) dikelompokkan secara terpisah. Proses ini penting untuk menyelesaikan persamaan dan memahami struktur dasar aljabar.";
    const mathQuestions = {
        "esai": [
            { question: "Sederhanakan bentuk aljabar berikut: 7x - 2y + 3x + 5y.", answer: "10x + 3y" },
            { question: "Apa yang dimaksud dengan 'suku sejenis' dalam aljabar? Berikan contoh!", answer: "Suku sejenis adalah suku yang memiliki variabel dan pangkat variabel yang sama. Contohnya 5a dan -2a adalah sejenis." }
        ],
        "pilihan_ganda": [
            { question: "Bentuk sederhana dari 8p - 3p adalah...", answer: "5p", distractors: ["5", "11p", "5p²"] },
            { question: "Hasil dari (4a + 2b) + (3a - b) adalah...", answer: "7a + b", distractors: ["a + b", "7a + 3b", "a + 3b"] },
            { question: "Koefisien dari variabel y pada bentuk 5x - 2y + 8 adalah...", answer: "-2", distractors: ["2", "5", "8"] },
            { question: "Sederhanakan ekspresi 2(x + 5) - 3.", answer: "2x + 7", distractors: ["2x + 2", "2x + 10", "x + 7"] },
            { question: "Manakah dari berikut ini yang merupakan suku sejenis dengan 3x²y?", answer: "-5x²y", distractors: ["3xy", "3x²", "-5xy²"] }
        ]
    };

    // --- FUNGSI UTAMA PROTOTIPE ---
    function startPrototypeFlow() {
        if (!document.getElementById('judul').value || !document.getElementById('mapel_id').value) {
            alert('Silakan isi Judul Materi dan pilih Mata Pelajaran terlebih dahulu.');
            return;
        }
        materiData.mapel_id = document.getElementById('mapel_id').value;
        materiData.judul = document.getElementById('judul').value;

        toggleLoading(true, 'Menganalisis dan meringkas materi...');
        setTimeout(() => {
            materiData.ringkasan = mathSummary;
            document.getElementById('summary-output').value = mathSummary;
            
            // --- PERBAIKAN DI SINI ---
            // Memastikan bagian upload disembunyikan dan bagian hasil ditampilkan
            uploadSection.style.display = 'none';
            resultSection.style.display = 'block';
            
            toggleLoading(false);
        }, 2500);
    }

    // Event Listener untuk Tombol Proses dari Kamera
    document.getElementById('process-camera-btn').addEventListener('click', startPrototypeFlow);

    // Event Listener untuk Form Unggah Berkas
    document.getElementById('upload-form').addEventListener('submit', (e) => {
        e.preventDefault();
        startPrototypeFlow();
    });

    // Event Listener untuk Buat Soal
    document.getElementById('generate-questions-btn').addEventListener('click', () => {
        const questionType = document.getElementById('question-type').value;
        toggleLoading(true, `Membuat soal ${questionType.replace('_', ' ')}...`);
        setTimeout(() => {
            materiData.soal = mathQuestions[questionType];
            renderQuestions(materiData.soal, questionType);
            document.getElementById('questions-output-container').style.display = 'block';
            toggleLoading(false);
        }, 2000);
    });

    // Event Listener untuk Simpan (menggunakan backend PHP asli)
    document.getElementById('save-all-btn').addEventListener('click', async () => {
        toggleLoading(true, 'Menyimpan ke bank soal...');
        try {
            const response = await fetch('../../materi.php?action=save_materi_dan_soal', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(materiData)
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.message);
            alert(result.message);
            window.location.href = 'dashboard.php';
        } catch (error) {
            alert('Gagal menyimpan: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });

    // --- Helper Functions ---
    function toggleLoading(show, text = 'Memproses...') {
        loadingOverlay.style.display = show ? 'flex' : 'none';
        loadingText.textContent = text;
    }
    
    function renderQuestions(questions, type) {
        const container = document.getElementById('questions-output');
        container.innerHTML = '';
        questions.forEach((q, index) => {
            const card = document.createElement('div');
            card.className = 'card mb-3';
            let body = `<div class="card-header"><b>Soal #${index + 1}</b></div><div class="card-body"><p><b>Pertanyaan:</b> ${q.question}</p>`;
            if (type === 'esai') {
                body += `<p><b>Kunci Jawaban:</b> ${q.answer}</p>`;
            } else {
                const options = [...q.distractors, q.answer].sort(() => Math.random() - 0.5);
                body += '<b>Pilihan:</b><ul class="list-group">';
                options.forEach(opt => {
                    const isCorrect = opt === q.answer;
                    body += `<li class="list-group-item ${isCorrect ? 'list-group-item-success' : ''}">${opt} ${isCorrect ? '(Benar)' : ''}</li>`;
                });
                body += '</ul>';
            }
            card.innerHTML = body + '</div>';
            container.appendChild(card);
        });
    }
});
</script>

<style>
    .camera-wrapper {
        position: relative; width: 100%;
        background-color: #f8f9fa; border: 1px solid #dee2e6;
        border-radius: .375rem; overflow: hidden;
    }
    #loading-overlay {
        position: absolute; top: 0; left: 0; right: 0; bottom: 0;
        background-color: rgba(255, 255, 255, 0.8); z-index: 1050;
        display: flex; flex-direction: column;
        justify-content: center; align-items: center;
        border-radius: .375rem;
    }
</style>