<?php 
$pageTitle = "Ambil dari Kamera";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/MataPelajaran.php';

$mapelModel = new MataPelajaran();
$daftarMapel = $mapelModel->getAll();
?>

<div class="card">
    <div class="card-body">
        <div class="d-flex align-items-center mb-3">
            <a href="unggah_materi.php" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Ambil Gambar dari Kamera</h4>
        </div>
        <hr>

        <div id="materi-info-form" class="row g-3 mb-3">
            <div class="col-md-6">
                <label for="mapel_id_kamera" class="form-label">Mata Pelajaran</label>
                <select class="form-select" id="mapel_id_kamera" name="mapel_id_kamera" required>
                    <option value="" disabled selected>-- Pilih Mata Pelajaran --</option>
                    <?php foreach ($daftarMapel as $mapel): ?>
                        <option value="<?= $mapel['mapel_id']; ?>"><?= htmlspecialchars($mapel['nama_pelajaran']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-6">
                <label for="judul_kamera" class="form-label">Judul Materi</label>
                <input type="text" class="form-control" id="judul_kamera" name="judul_kamera" required placeholder="Contoh: Bab 2 - Optik Geometris">
            </div>
        </div>

        <div id="step-camera">
            <p class="text-muted">Posisikan kamera ke teks materi, lalu ambil gambar.</p>
            <div class="camera-wrapper mb-3">
                <video id="cameraFeed" autoplay playsinline></video>
                <canvas id="imageCanvas" style="display:none;"></canvas>
            </div>
            <div class="d-grid">
                <button id="captureButton" class="btn btn-dark btn-lg"><i class="bi bi-camera-fill me-2"></i>Ambil Gambar</button>
            </div>
        </div>
        
        <div id="step-preview" style="display:none;">
             <p class="text-muted">Gambar berhasil diambil. Lanjutkan untuk memproses.</p>
             <img id="capturedImage" class="img-fluid rounded mb-3" alt="Captured Image">
             <div class="d-grid gap-2">
                <button id="processButton" class="btn btn-primary btn-lg">Proses dan Ringkas</button>
                <button id="retakeButton" class="btn btn-secondary">Ambil Ulang</button>
             </div>
        </div>

        <div id="step-summary" style="display: none;">
            <div class="mb-3">
                <label class="form-label fw-bold">Hasil Ringkasan Materi</label>
                <textarea class="form-control" id="summaryResult" rows="8" readonly></textarea>
            </div>
            <div class="d-grid gap-2">
                <button type="button" id="generateQuestionButton" class="btn btn-info btn-lg">
                    <i class="bi bi-stars me-2"></i>Buat Soal Otomatis
                </button>
            </div>
        </div>
        
        <div id="step-questions" style="display: none;">
             <hr>
             <h5 class="fw-bold">Hasil Soal Otomatis</h5>
             <div id="questionList" class="mb-3"></div>
             <div class="d-grid">
                <button type="button" id="saveButton" class="btn btn-success btn-lg">Simpan Materi & Soal</button>
             </div>
        </div>

        <div id="loading-indicator" class="text-center my-5" style="display: none;">
            <div class="spinner-border text-primary" role="status"></div>
            <p class="mt-3" id="loadingText">Mohon tunggu...</p>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', async () => {
    // Sesuaikan URL API Flask Anda di sini
    const API_URL = '<?= FLASK_API_URL ?>';
    
    // Elemen UI
    const materiInfoForm = document.getElementById('materi-info-form');
    const stepCamera = document.getElementById('step-camera');
    const stepPreview = document.getElementById('step-preview');
    const stepSummary = document.getElementById('step-summary');
    const stepQuestions = document.getElementById('step-questions');
    const loading = document.getElementById('loading-indicator');
    const loadingText = document.getElementById('loadingText');

    // Elemen Interaktif
    const video = document.getElementById('cameraFeed');
    const canvas = document.getElementById('imageCanvas');
    const captureButton = document.getElementById('captureButton');
    const capturedImage = document.getElementById('capturedImage');
    const processButton = document.getElementById('processButton');
    const retakeButton = document.getElementById('retakeButton');
    const generateQuestionButton = document.getElementById('generateQuestionButton');
    const saveButton = document.getElementById('saveButton');
    const summaryResult = document.getElementById('summaryResult');
    const questionList = document.getElementById('questionList');
    
    // Variabel state
    let imageBlob = null;
    let generatedQuestions = [];

    // Fungsi untuk menampilkan step tertentu
    function showStep(stepElement) {
        [stepCamera, stepPreview, stepSummary, stepQuestions, loading].forEach(el => el.style.display = 'none');
        stepElement.style.display = 'block';
    }

    // Inisialisasi kamera
    try {
        const stream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } });
        video.srcObject = stream;
    } catch (err) {
        alert("Tidak bisa mengakses kamera. Pastikan Anda memberikan izin dan menggunakan koneksi HTTPS jika di server.");
    }

    captureButton.addEventListener('click', () => {
        if (!document.getElementById('judul_kamera').value || !document.getElementById('mapel_id_kamera').value) {
            alert('Silakan isi Judul Materi dan pilih Mata Pelajaran terlebih dahulu.');
            return;
        }
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
        canvas.getContext('2d').drawImage(video, 0, 0);
        canvas.toBlob(blob => {
            imageBlob = blob;
            capturedImage.src = URL.createObjectURL(blob);
            showStep(stepPreview);
            materiInfoForm.style.display = 'none'; // Sembunyikan form info
        }, 'image/jpeg');
    });
    
    retakeButton.addEventListener('click', () => {
        imageBlob = null;
        showStep(stepCamera);
        materiInfoForm.style.display = 'flex'; // Tampilkan lagi form info
    });

    processButton.addEventListener('click', async () => {
        if (!imageBlob) return;
        showStep(loading);
        loadingText.textContent = 'Memproses gambar dengan ICR & NLP...';
        
        const formData = new FormData();
        formData.append('file', imageBlob, 'capture.jpg');
        
        try {
            const response = await fetch(`${API_URL}/process-image`, { method: 'POST', body: formData });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error);
            
            summaryResult.value = result.summary;
            showStep(stepSummary);
        } catch (error) {
            alert('Error: ' + error.message);
            showStep(stepPreview);
        }
    });

    generateQuestionButton.addEventListener('click', async () => {
        const summaryText = summaryResult.value;
        showStep(loading);
        loadingText.textContent = 'Membuat soal otomatis...';

        try {
            const response = await fetch(`${API_URL}/generate-questions`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ text: summaryText }),
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error);

            questionList.innerHTML = '';
            generatedQuestions = result.questions || []; // Simpan soal ke variabel

            if (generatedQuestions.length > 0) {
                 const list = document.createElement('ul');
                 list.className = 'list-group';
                 generatedQuestions.forEach(q => {
                    const listItem = document.createElement('li');
                    listItem.className = 'list-group-item';
                    listItem.innerHTML = `<strong>P:</strong> ${q.question}<br><strong>J:</strong> ${q.answer}`;
                    list.appendChild(listItem);
                 });
                 questionList.appendChild(list);
            } else {
                questionList.textContent = 'Tidak ada soal yang dapat dibuat dari ringkasan ini.';
            }
            showStep(stepQuestions);
        } catch (error) {
            alert('Error: ' + error.message);
            showStep(stepSummary);
        }
    });
    
    saveButton.addEventListener('click', async () => {
        showStep(loading);
        loadingText.textContent = 'Menyimpan materi dan soal...';

        const dataToSave = {
            judul: document.getElementById('judul_kamera').value,
            mapel_id: document.getElementById('mapel_id_kamera').value,
            ringkasan: summaryResult.value,
            questions: generatedQuestions
        };

        try {
            const response = await fetch('../../materi.php?action=save_from_camera', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(dataToSave)
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.message);

            alert(result.message);
            window.location.href = result.redirect_url;

        } catch (error) {
            alert('Gagal menyimpan data: ' + error.message);
            showStep(stepQuestions);
        }
    });
});
</script>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>