<?php 
$pageTitle = "Unggah & Proses Materi";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/MataPelajaran.php';

$mapelModel = new MataPelajaran();
$daftarMapel = $mapelModel->getAll();
?>

<div class="card shadow-sm">
    <div class="card-body p-4">

        <div id="loading-overlay" style="display: none;">
            <div class="spinner-border text-primary" role="status"></div>
            <p id="loading-text" class="mt-3">Memproses...</p>
        </div>

        <div id="step-1-upload">
            <div class="d-flex align-items-center mb-3">
                <a href="dashboard.php" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
                <h4 class="m-0">Unggah Berkas Materi</h4>
            </div>
            <hr>
            <p class="text-muted">Isi detail materi dan unggah berkas (PDF, DOCX, JPG, PNG) untuk diringkas dan dibuatkan soal secara otomatis.</p>
            <form id="upload-form" enctype="multipart/form-data">
                 <div class="mb-3">
                    <label for="mapel_id" class="form-label">Mata Pelajaran</label>
                    <select class="form-select" id="mapel_id" name="mapel_id" required>
                        <option value="" disabled selected>-- Pilih Mata Pelajaran --</option>
                        <?php foreach ($daftarMapel as $mapel): ?>
                            <option value="<?= $mapel['mapel_id']; ?>"><?= htmlspecialchars($mapel['nama_pelajaran']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="judul" class="form-label">Judul Materi</label>
                    <input type="text" class="form-control" id="judul" name="judul" required placeholder="Contoh: Dasar-Dasar Fotografi">
                </div>
                <div class="mb-3">
                    <label for="file_materi" class="form-label">Berkas Materi</label>
                    <input class="form-control" type="file" id="file_materi" name="file_materi" accept="image/jpeg, image/png, application/pdf, application/vnd.openxmlformats-officedocument.wordprocessingml.document" required>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg">Proses & Ringkas Materi</button>
                </div>
            </form>
        </div>

        <div id="steps-after-upload" style="display: none;">
            <h4 class="mb-3">Hasil Proses Otomatis</h4>
            <hr>
            <div id="summaries-container" class="mb-3">
                <label class="form-label fw-bold">Pilih Ringkasan untuk Dibuatkan Soal:</label>
                <!-- Ringkasan akan dimasukkan di sini oleh JavaScript -->
            </div>
            
            <div id="questions-output-container" class="mt-4" style="display: none;">
                <h5 class="fw-bold">Tinjau Soal</h5>
                <div id="questions-output" class="mb-3"></div>
                <div class="d-grid">
                    <button id="save-all-btn" class="btn btn-success btn-lg">Simpan Materi & Soal ke Bank Soal</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // State object to store data
    const materiData = { mapel_id: null, judul: null, ringkasan: '', soal: [] };

    // UI Elements
    const loadingOverlay = document.getElementById('loading-overlay');
    const loadingText = document.getElementById('loading-text');
    const uploadForm = document.getElementById('upload-form');
    const step1Upload = document.getElementById('step-1-upload');
    const stepsAfterUpload = document.getElementById('steps-after-upload');
    const summariesContainer = document.getElementById('summaries-container');
    const questionsOutputContainer = document.getElementById('questions-output-container');
    const questionsOutput = document.getElementById('questions-output');
    const saveAllBtn = document.getElementById('save-all-btn');

    // === API URL (Ganti ini setelah backend di-deploy) ===
    const API_BACKEND_URL = '<?= FLASK_API_URL ?>';

    // --- MAIN APP FLOW ---

    // 1. Handle form submission to process material
    uploadForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const fileInput = document.getElementById('file_materi');
        if (fileInput.files.length === 0) {
            alert('Silakan pilih berkas materi terlebih dahulu.');
            return;
        }

        materiData.mapel_id = document.getElementById('mapel_id').value;
        materiData.judul = document.getElementById('judul').value;

        const formData = new FormData();
        formData.append('file', fileInput.files[0]);
        
        toggleLoading(true, 'Membaca dan meringkas materi...');

        try {
            const response = await fetch(`${API_BACKEND_URL}/process-material`, {
                method: 'POST',
                body: formData
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error);

            renderSummaries(result.summaries);
            step1Upload.style.display = 'none';
            stepsAfterUpload.style.display = 'block';

        } catch (error) {
            alert('Gagal memproses materi: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });

    // 2. Handle click on a summary to generate questions
    summariesContainer.addEventListener('click', async (e) => {
        if (e.target && e.target.classList.contains('generate-btn')) {
            const summaryText = e.target.dataset.summary;
            materiData.ringkasan += summaryText + '\n\n'; // Append summary

            const numQuestions = prompt("Berapa soal yang ingin dibuat dari ringkasan ini? (1-3)", "2");
            if (!numQuestions || numQuestions < 1 || numQuestions > 3) return;

            toggleLoading(true, `Membuat ${numQuestions} soal...`);
            
            try {
                const response = await fetch(`${API_BACKEND_URL}/generate-questions`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ summary: summaryText, num_questions: numQuestions })
                });
                const result = await response.json();
                if (!response.ok) throw new Error(result.error);

                materiData.soal.push(...result.questions);
                renderQuestions(materiData.soal);
                questionsOutputContainer.style.display = 'block';

            } catch (error) {
                alert('Gagal membuat soal: ' + error.message);
            } finally {
                toggleLoading(false);
            }
        }
    });

    // 3. Save all collected materials and questions
    saveAllBtn.addEventListener('click', async () => {
        toggleLoading(true, 'Menyimpan ke bank soal...');
        try {
            const response = await fetch('../../materi.php?action=save_materi_dan_soal', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(materiData)
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.message);
            alert(result.message);
            window.location.href = result.redirect_url;
        } catch (error) {
            alert('Gagal menyimpan: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });

    // --- HELPER FUNCTIONS ---

    function renderSummaries(summaries) {
        summariesContainer.innerHTML = '<label class="form-label fw-bold">Pilih Ringkasan untuk Dibuatkan Soal:</label>';
        if (!summaries || summaries.length === 0) {
            summariesContainer.innerHTML += '<p class="text-muted">Tidak ada ringkasan yang dapat dibuat.</p>';
            return;
        }
        summaries.forEach(s => {
            summariesContainer.innerHTML += `
                <div class="card mb-2">
                    <div class="card-body">
                        <p class="card-text">${s.summary_text}</p>
                        <button class="btn btn-info btn-sm text-white generate-btn" data-summary="${s.summary_text.replace(/"/g, '&quot;')}">
                            <i class="bi bi-stars"></i> Buat Soal dari Sini
                        </button>
                    </div>
                </div>
            `;
        });
    }

    function renderQuestions(questions) {
        questionsOutput.innerHTML = '';
        questions.forEach((q, index) => {
            const card = document.createElement('div');
            card.className = 'card mb-3';
            card.innerHTML = `
                <div class="card-header"><b>Soal #${index + 1}</b></div>
                <div class="card-body">
                    <p><b>Pertanyaan:</b> ${q.question}</p>
                    <p class="mb-0"><b>Kunci Jawaban:</b> ${q.answer}</p>
                </div>
            `;
            questionsOutput.appendChild(card);
        });
    }

    function toggleLoading(show, text = 'Memproses...') {
        loadingOverlay.style.display = show ? 'flex' : 'none';
        loadingText.textContent = text;
    }
});
</script>

<style>
    #loading-overlay {
        position: absolute; top: 0; left: 0; right: 0; bottom: 0;
        background-color: rgba(255, 255, 255, 0.8); z-index: 1050;
        display: flex; flex-direction: column;
        justify-content: center; align-items: center;
        border-radius: .375rem;
    }
</style>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>
