<?php 
$pageTitle = "Rekapitulasi Ujian";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/UjianGuru.php';

$model = new UjianGuru();
$daftarUjian = $model->getAllUjian();
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex align-items-center mb-3">
            <a href="<?= BASE_URL ?>/dashboard-guru" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Pilih Ujian untuk Melihat Rekapitulasi</h4>
        </div>
        <hr>
        <div class="list-group">
            <?php if (empty($daftarUjian)): ?>
                <div class="list-group-item text-center">Belum ada ujian yang dibuat.</div>
            <?php else: ?>
                <?php foreach ($daftarUjian as $ujian): ?>
                    <a href="<?= BASE_URL ?>/detail-hasil?ujian_id=<?= $ujian['ujian_id'] ?>&judul=<?= urlencode($ujian['judul_ujian']) ?>" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1"><?= htmlspecialchars($ujian['judul_ujian']) ?></h5>
                            <small>Kode: <?= htmlspecialchars($ujian['kode_ujian']) ?></small>
                        </div>
                        <p class="mb-1">Mapel: <?= htmlspecialchars($ujian['nama_pelajaran']) ?></p>
                        <small>Jumlah Soal: <?= $ujian['jumlah_soal'] ?></small>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>