<?php 
$pageTitle = "Manajemen Materi & Soal";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/KelolaSoal.php';

$db = Database::getInstance()->getConnection();
$model = new KelolaSoal($db);
$daftarMapel = $model->getSoalGroupByMapelByGuru($_SESSION['user_id']);
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex align-items-center mb-3">
            <a href="<?= BASE_URL ?>/dashboard-guru" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Manajemen Soal per Mata Pelajaran</h4>
        </div>
        <hr>

        <?php if (isset($_SESSION['flash_message'])) {
            $message = $_SESSION['flash_message'];
            echo '<div class="alert alert-' . htmlspecialchars($message['type']) . '" role="alert">' . $message['text'] . '</div>';
            unset($_SESSION['flash_message']);
        } ?>
        
        <div class="accordion" id="accordionMapel">
            <?php if(empty($daftarMapel)): ?>
                <div class="alert alert-info">Anda belum membuat soal apapun.</div>
            <?php else: ?>
                <?php foreach($daftarMapel as $index => $mapel): ?>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="heading-<?= $mapel['mapel_id'] ?>">
                        <button class="accordion-button <?= $index > 0 ? 'collapsed' : '' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?= $mapel['mapel_id'] ?>">
                            <strong><?= htmlspecialchars($mapel['nama_pelajaran']) ?></strong>&nbsp; (<?= count($mapel['soal']) ?> soal)
                        </button>
                    </h2>
                    <div id="collapse-<?= $mapel['mapel_id'] ?>" class="accordion-collapse collapse <?= $index == 0 ? 'show' : '' ?>" data-bs-parent="#accordionMapel">
                        <div class="accordion-body">
                            <table class="table table-striped table-hover">
                                <thead><tr><th>No</th><th>Pertanyaan</th><th>Jenis</th><th>Status</th><th>Aksi</th></tr></thead>
                                <tbody>
                                    <?php foreach($mapel['soal'] as $idx => $soal): ?>
                                    <tr>
                                        <td><?= $idx + 1 ?></td>
                                        <td><?= htmlspecialchars(substr($soal['pertanyaan'], 0, 70)) . '...' ?></td>
                                        <td><?= htmlspecialchars($soal['jenis_soal']) ?></td>
                                        <td>
                                            <?php
                                                $statusClass = ['Pending' => 'secondary', 'Disetujui' => 'success', 'Ditolak' => 'danger'];
                                                $badge = $statusClass[$soal['status_validasi']] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?= $badge ?>"><?= $soal['status_validasi'] ?></span>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal" data-soal-id="<?= $soal['soal_id'] ?>" data-pertanyaan="<?= htmlspecialchars($soal['pertanyaan']) ?>"><i class="bi bi-pencil-fill"></i></button>
                                            <form action="<?= BASE_URL ?>/soal/delete" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus?');">
                                                <input type="hidden" name="soal_id" value="<?= $soal['soal_id'] ?>">
                                                <button type="submit" class="btn btn-danger btn-sm"><i class="bi bi-trash-fill"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
    <div class="modal-header"><h5 class="modal-title">Sunting Soal</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <form action="<?= BASE_URL ?>/soal/update" method="POST">
        <div class="modal-body">
            <input type="hidden" name="soal_id" id="modal_soal_id">
            <div class="alert alert-warning small">Catatan: Mengubah soal akan mengembalikan statusnya menjadi "Pending" untuk divalidasi ulang.</div>
            <div class="mb-3">
                <label for="modal_pertanyaan" class="form-label">Teks Pertanyaan</label>
                <textarea class="form-control" name="pertanyaan" id="modal_pertanyaan" rows="5" required></textarea>
            </div>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button><button type="submit" class="btn btn-primary">Simpan</button></div>
    </form>
</div></div></div>

<script>
document.getElementById('editModal')?.addEventListener('show.bs.modal', e => {
    const btn = e.relatedTarget;
    e.currentTarget.querySelector('#modal_soal_id').value = btn.getAttribute('data-soal-id');
    e.currentTarget.querySelector('#modal_pertanyaan').value = btn.getAttribute('data-pertanyaan');
});
</script>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>