<?php 
$ujianId = $_GET['ujian_id'] ?? null;
$judulUjian = $_GET['judul'] ?? 'Detail Hasil';
if (!$ujianId) die("Ujian tidak valid.");

$pageTitle = "Detail Hasil: " . htmlspecialchars(urldecode($judulUjian));
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/UjianGuru.php';

$model = new UjianGuru();
$hasilSiswa = $model->getHasilByUjian($ujianId);
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex align-items-center mb-3">
            <a href="<?= BASE_URL ?>/rekap-ujian" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Rekapitulasi: <?= htmlspecialchars(urldecode($judulUjian)) ?></h4>
        </div>
        <hr>
        <table class="table table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Nama Siswa</th>
                    <th>Kelas</th>
                    <th>Skor Akhir</th>
                    <th>Waktu Mengerjakan</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($hasilSiswa)): ?>
                    <tr><td colspan="5" class="text-center">Belum ada siswa yang mengerjakan ujian ini.</td></tr>
                <?php else: ?>
                    <?php foreach ($hasilSiswa as $index => $hasil): ?>
                        <tr>
                            <td><?= $index + 1 ?></td>
                            <td><?= htmlspecialchars($hasil['nama_siswa']) ?></td>
                            <td><?= htmlspecialchars($hasil['kelas']) ?></td>
                            <td><?= number_format($hasil['skor_akhir'], 2) ?></td>
                            <td><?= date('d M Y, H:i', strtotime($hasil['waktu_mengerjakan'])) ?> WIB</td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>