<?php 
$pageTitle = "Dashboard Guru";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/Dashboard.php';
require_once __DIR__ . '/../../models/UjianGuru.php';

$db = Database::getInstance()->getConnection();
$dashboardModel = new Dashboard($db);
$ujianModel = new UjianGuru($db);

$counts = $dashboardModel->getSummaryCounts($_SESSION['user_id']);
$ujianTerbaru = $ujianModel->getAllUjianByGuru($_SESSION['user_id']);
?>

<div class="container-fluid">
    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <div class="card summary-card shadow-sm"><div class="card-body d-flex align-items-center"><div class="icon bg-light text-success rounded-circle p-3 me-3"><i class="bi bi-journal-text fs-2"></i></div><div><h3 class="card-title mb-0"><?= $counts['total_materi'] ?></h3><p class="card-text text-muted">Materi Dibuat</p></div></div></div>
        </div>
        <div class="col-md-4">
            <div class="card summary-card shadow-sm"><div class="card-body d-flex align-items-center"><div class="icon bg-light text-primary rounded-circle p-3 me-3"><i class="bi bi-patch-question-fill fs-2"></i></div><div><h3 class="card-title mb-0"><?= $counts['total_soal'] ?></h3><p class="card-text text-muted">Soal di Bank Soal</p></div></div></div>
        </div>
        <div class="col-md-4">
            <div class="card summary-card shadow-sm"><div class="card-body d-flex align-items-center"><div class="icon bg-light text-info rounded-circle p-3 me-3"><i class="bi bi-file-earmark-check-fill fs-2"></i></div><div><h3 class="card-title mb-0"><?= count($ujianTerbaru) ?></h3><p class="card-text text-muted">Ujian Dibuat</p></div></div></div>
        </div>
    </div>

    <div class="card shadow-sm mb-4">
        <div class="card-header"><h5 class="card-title m-0">Aksi Cepat</h5></div>
        <div class="card-body"><div class="row text-center g-3">
            <div class="col-md-4 action-card"><a href="<?= BASE_URL ?>/buat-materi-baru" class="text-decoration-none p-4 rounded bg-light"><i class="bi bi-cloud-arrow-up-fill text-primary"></i><span class="mt-2">Buat Materi & Soal (AI)</span></a></div>
            <div class="col-md-4 action-card"><a href="<?= BASE_URL ?>/buat-ujian" class="text-decoration-none p-4 rounded bg-light"><i class="bi bi-journal-plus text-success"></i><span class="mt-2">Buat Paket Ujian</span></a></div>
            <div class="col-md-4 action-card"><a href="<?= BASE_URL ?>/rekap-ujian" class="text-decoration-none p-4 rounded bg-light"><i class="bi bi-graph-up text-info"></i><span class="mt-2">Lihat Rekap Ujian</span></a></div>
        </div></div>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header"><h5 class="card-title m-0">Rekapitulasi Ujian Terbaru</h5></div>
        <div class="card-body"><div class="table-responsive"><table class="table table-hover">
            <thead><tr><th>Judul Ujian</th><th>Mata Pelajaran</th><th>Kode Ujian</th><th>Jumlah Soal</th><th>Aksi</th></tr></thead>
            <tbody>
                <?php if (empty($ujianTerbaru)): ?>
                    <tr><td colspan="5" class="text-center text-muted">Belum ada ujian yang dibuat.</td></tr>
                <?php else: ?>
                    <?php foreach (array_slice($ujianTerbaru, 0, 5) as $ujian): ?>
                        <tr>
                            <td><?= htmlspecialchars($ujian['judul_ujian']) ?></td>
                            <td><?= htmlspecialchars($ujian['nama_pelajaran']) ?></td>
                            <td><span class="badge bg-secondary"><?= htmlspecialchars($ujian['kode_ujian']) ?></span></td>
                            <td><?= $ujian['jumlah_soal'] ?></td>
                            <td><a href="<?= BASE_URL ?>/detail-hasil?ujian_id=<?= $ujian['ujian_id'] ?>&judul=<?= urlencode($ujian['judul_ujian']) ?>" class="btn btn-sm btn-outline-primary">Lihat Hasil</a></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table></div></div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>