<?php 
$pageTitle = "Buat Ujian Baru";
require_once __DIR__ . '/../layouts/main_header.php';
require_once __DIR__ . '/../../models/MataPelajaran.php';

$mapelModel = new MataPelajaran();
$daftarMapel = $mapelModel->getAll();
?>

<div class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex align-items-center mb-3">
            <a href="<?= BASE_URL ?>/dashboard-guru" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
            <h4 class="m-0">Buat Paket Ujian Baru</h4>
        </div>
        <hr>
        
        <form action="<?= BASE_URL; ?>/ujian/save" method="POST">
            <div class="row">
                <div class="col-md-8 mb-3">
                    <label for="judul_ujian" class="form-label">Judul Ujian</label>
                    <input type="text" class="form-control" id="judul_ujian" name="judul_ujian" placeholder="Contoh: Ujian Tengah Semester Ganjil" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="mapel_id" class="form-label">Mata Pelajaran</label>
                    <select class="form-select" id="mapel_id" name="mapel_id" required>
                        <option value="" disabled selected>-- Pilih Mapel --</option>
                        <?php foreach ($daftarMapel as $mapel): ?>
                            <option value="<?= $mapel['mapel_id']; ?>"><?= htmlspecialchars($mapel['nama_pelajaran']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <hr>
            <h5 class="mb-3">Pilih Soal dari Bank Soal (Hanya Soal yang Telah Disetujui)</h5>
            <div id="soal-list-container" class="vstack gap-2">
                <div class="alert alert-info text-center">Pilih mata pelajaran terlebih dahulu untuk menampilkan soal yang tersedia.</div>
            </div>

            <div class="d-grid mt-4">
                <button type="submit" class="btn btn-success btn-lg">Simpan Ujian</button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('mapel_id').addEventListener('change', async function() {
    const mapelId = this.value;
    const container = document.getElementById('soal-list-container');
    
    if (!mapelId) {
        container.innerHTML = '<div class="alert alert-info text-center">Pilih mata pelajaran terlebih dahulu.</div>';
        return;
    }
    
    container.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"></div><p>Memuat soal...</p></div>';

    try {
        const response = await fetch(`<?= BASE_URL ?>/api/get-soal-by-mapel?mapel_id=${mapelId}`);
        const soalList = await response.json();

        if (soalList.error) throw new Error(soalList.error);
        
        if (soalList.length === 0) {
            container.innerHTML = '<div class="alert alert-warning text-center">Tidak ada soal yang disetujui untuk mata pelajaran ini.</div>';
            return;
        }

        let html = '';
        soalList.forEach(soal => {
            html += `
                <div class="form-check border p-3 rounded">
                    <input class="form-check-input" type="checkbox" name="soal_ids[]" value="${soal.soal_id}" id="soal-${soal.soal_id}">
                    <label class="form-check-label w-100" for="soal-${soal.soal_id}">
                        <span class="badge bg-secondary me-2">${soal.jenis_soal}</span>
                        ${soal.pertanyaan}
                    </label>
                </div>
            `;
        });
        container.innerHTML = html;

    } catch (error) {
        container.innerHTML = `<div class="alert alert-danger text-center">Gagal memuat soal: ${error.message}</div>`;
    }
});
</script>

<?php require_once __DIR__ . '/../layouts/main_footer.php'; ?>