<?php 
$pageTitle = "Buat Materi & Soal Baru";
// PERBAIKAN: Gunakan ROOT_PATH untuk path yang andal
require_once ROOT_PATH . '/views/layouts/main_header.php';
require_once ROOT_PATH . '/models/MataPelajaran.php';

$db = Database::getInstance()->getConnection();
$mapelModel = new MataPelajaran($db);
$daftarMapel = $mapelModel->getAll();
?>

<div class="card shadow-sm">
    <div class="card-body p-4 position-relative">

        <div id="loading-overlay" class="d-none">
            <div class="spinner-border text-primary" role="status"></div>
            <p id="loading-text" class="mt-3">Memproses...</p>
        </div>

        <div id="step-1-upload">
            <div class="d-flex align-items-center mb-3">
                <a href="<?= BASE_URL ?>/dashboard-guru" class="btn btn-light me-3"><i class="bi bi-arrow-left"></i></a>
                <h4 class="m-0">Langkah 1: Pilih Sumber & Ekstrak Teks</h4>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-6 mb-3"><label for="mapel_id" class="form-label">Mata Pelajaran</label><select class="form-select" id="mapel_id" name="mapel_id" required><option value="" disabled selected>-- Pilih --</option><?php foreach ($daftarMapel as $mapel) : ?><option value="<?= $mapel['mapel_id']; ?>"><?= htmlspecialchars($mapel['nama_pelajaran']); ?></option><?php endforeach; ?></select></div>
                <div class="col-md-6 mb-3"><label for="judul" class="form-label">Judul Materi</label><input type="text" class="form-control" id="judul" name="judul" required placeholder="Contoh: Bab 1 - Pengenalan Aljabar"></div>
            </div>
            
            <ul class="nav nav-tabs nav-fill mb-3" id="source-tab" role="tablist">
                <li class="nav-item" role="presentation"><button class="nav-link active" id="upload-tab-btn" data-bs-toggle="tab" data-bs-target="#upload-pane" type="button"><i class="bi bi-file-earmark-arrow-up-fill me-2"></i>Unggah Berkas</button></li>
                <li class="nav-item" role="presentation"><button class="nav-link" id="camera-tab-btn" data-bs-toggle="tab" data-bs-target="#camera-pane" type="button"><i class="bi bi-camera-fill me-2"></i>Gunakan Kamera</button></li>
            </ul>

            <div class="tab-content p-3 border border-top-0 rounded-bottom" id="source-tab-content">
                <div class="tab-pane fade show active" id="upload-pane" role="tabpanel">
                    <div class="mb-3"><label for="file_materi" class="form-label">Pilih Berkas (JPG, PNG, PDF)</label><input class="form-control" type="file" id="file_materi" accept="image/jpeg,image/png,application/pdf"></div>
                    <div class="d-grid"><button type="button" id="submit-file-btn" class="btn btn-primary btn-lg">Proses Berkas <i class="bi bi-arrow-right"></i></button></div>
                </div>
                <div class="tab-pane fade" id="camera-pane" role="tabpanel">
                    <div id="camera-view">
                         <div class="camera-wrapper mb-3"><video id="camera-feed" autoplay playsinline></video></div>
                         <div class="d-grid"><button type="button" id="capture-btn" class="btn btn-dark">Ambil Gambar</button></div>
                    </div>
                    <div id="preview-view" class="d-none">
                        <p class="text-center text-muted">Pratinjau Gambar:</p>
                        <img id="captured-image" class="img-fluid rounded mb-3" alt="Captured Image">
                        <div class="d-flex justify-content-center gap-2">
                            <button type="button" id="retake-btn" class="btn btn-secondary">Ambil Ulang</button>
                            <button type="button" id="submit-camera-btn" class="btn btn-primary">Proses Gambar Ini <i class="bi bi-arrow-right"></i></button>
                        </div>
                    </div>
                    <canvas id="image-canvas" class="d-none"></canvas>
                </div>
            </div>
        </div>

        <div id="step-2-verify" class="d-none">
            <h4 class="mb-3">Langkah 2: Verifikasi & Ringkas Teks</h4><hr>
            <div class="mb-3">
                <label for="extracted_text_area" class="form-label fw-bold">Teks Hasil Ekstraksi AI</label>
                <p class="text-muted small">Periksa dan perbaiki teks di bawah ini jika ada kesalahan sebelum melanjutkan.</p>
                <textarea id="extracted_text_area" class="form-control" rows="10"></textarea>
            </div>
            <div class="d-flex justify-content-between">
                <button id="summarize-btn" class="btn btn-info text-white"><i class="bi bi-stars"></i> Buat Ringkasan (Otomatis)</button>
                <button id="goto-questions-btn" class="btn btn-primary btn-lg">Lanjut Buat Soal <i class="bi bi-arrow-right"></i></button>
            </div>
            <div id="summary-container" class="mt-4 d-none">
                 <label for="summary_text_area" class="form-label fw-bold">Hasil Ringkasan AI (Bisa Diedit)</label>
                 <textarea id="summary_text_area" class="form-control" rows="5"></textarea>
            </div>
        </div>
        
        <div id="step-3-questions" class="d-none">
             <h4 class="mb-3">Langkah 3: Pembuatan Soal</h4><hr>
             <div class="row gx-4">
                <div class="col-md-5">
                    <h5>Buat Soal Baru</h5>
                    <div class="nav nav-tabs" id="question-creation-tab" role="tablist">
                        <button class="nav-link active" id="manual-tab" data-bs-toggle="tab" data-bs-target="#manual-pane">Manual</button>
                        <button class="nav-link" id="ai-tab" data-bs-toggle="tab" data-bs-target="#ai-pane">Otomatis (AI)</button>
                    </div>
                    <div class="tab-content border border-top-0 p-3 rounded-bottom">
                        <div class="tab-pane fade show active" id="manual-pane">
                           <form id="manual-question-form" onsubmit="return false;"><p class="small text-muted mb-2">Isi detail soal secara manual.</p>
                                <div class="mb-2"><textarea class="form-control" id="manual-question" placeholder="Tulis pertanyaan..." rows="3" required></textarea></div>
                                <div class="mb-2"><input type="text" class="form-control" id="manual-answer" placeholder="Tulis jawaban benar" required></div>
                                <div id="manual-distractors-container" class="mb-2">
                                    <input type="text" class="form-control form-control-sm mb-1" placeholder="Pilihan pengecoh 1">
                                    <input type="text" class="form-control form-control-sm mb-1" placeholder="Pilihan pengecoh 2">
                                    <input type="text" class="form-control form-control-sm mb-1" placeholder="Pilihan pengecoh 3">
                                </div>
                                <div class="form-check mb-2"><input class="form-check-input" type="checkbox" id="is-essay-checkbox"><label class="form-check-label" for="is-essay-checkbox">Tandai sebagai soal Esai</label></div>
                                <div class="d-grid"><button type="submit" class="btn btn-secondary">Tambah Soal</button></div>
                           </form>
                        </div>
                        <div class="tab-pane fade" id="ai-pane">
                            <p class="small text-muted mb-2">Buat soal secara otomatis dari teks.</p>
                            <div class="mb-2"><label class="form-label">Sumber Teks:</label><select id="ai-text-source" class="form-select form-select-sm"><option value="summary">Dari Ringkasan</option><option value="full_text">Dari Teks Lengkap</option></select></div>
                            <div class="mb-2"><label class="form-label">Jenis Soal:</label><select id="ai-question-type" class="form-select form-select-sm"><option value="pilihan_ganda">Pilihan Ganda</option><option value="esai">Esai</option></select></div>
                             <div class="d-grid"><button id="ai-generate-btn" class="btn btn-info text-white">Buat 3 Soal dengan AI</button></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-7">
                    <h5>Daftar Soal Ujian</h5>
                    <div id="question-list-container" class="list-group" style="max-height: 400px; overflow-y: auto;">
                       <div class="list-group-item text-center text-muted">Belum ada soal yang dibuat.</div>
                    </div>
                </div>
             </div>
             <hr class="mt-4">
             <div class="d-grid">
                <button id="save-all-btn" class="btn btn-success btn-lg">Selesai & Simpan Semua ke Bank Soal</button>
             </div>
        </div>
    </div>
</div>

<style>
    #loading-overlay { position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(255, 255, 255, 0.85); z-index: 1050; display: flex; flex-direction: column; justify-content: center; align-items: center; border-radius: .375rem; }
    .d-none { display: none !important; }
    .camera-wrapper { position: relative; width: 100%; background-color: #000; border-radius: 0.5rem; overflow: hidden; }
    #camera-feed { width: 100%; height: auto; display: block; transform: scaleX(-1); }
</style>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const API_URL = '<?= FLASK_API_URL ?>';
    const state = { mapel_id: null, judul: null, teks_asli: '', ringkasan: '', soal: [] };

    const ui = {
        loadingOverlay: document.getElementById('loading-overlay'),
        loadingText: document.getElementById('loading-text'),
        steps: { upload: document.getElementById('step-1-upload'), verify: document.getElementById('step-2-verify'), questions: document.getElementById('step-3-questions') },
        fileInput: document.getElementById('file_materi'),
        cameraFeed: document.getElementById('camera-feed'),
        imageCanvas: document.getElementById('image-canvas'),
        captureBtn: document.getElementById('capture-btn'),
        capturedImage: document.getElementById('captured-image'),
        cameraView: document.getElementById('camera-view'),
        previewView: document.getElementById('preview-view'),
        retakeBtn: document.getElementById('retake-btn'),
        manualForm: document.getElementById('manual-question-form'),
        questionListContainer: document.getElementById('question-list-container')
    };

    function showStep(stepName) {
        Object.values(ui.steps).forEach(step => step.classList.add('d-none'));
        ui.steps[stepName].classList.remove('d-none');
    }

    function toggleLoading(show, text = 'Memproses...') {
        ui.loadingText.textContent = text;
        ui.loadingOverlay.classList.toggle('d-none', !show);
    }

    async function handleSubmission(source) {
        const mapelId = document.getElementById('mapel_id').value;
        const judul = document.getElementById('judul').value;
        if (!mapelId || !judul) {
            alert('Harap isi Mata Pelajaran dan Judul Materi.');
            return;
        }
        if (!source) {
            alert('Harap pilih berkas atau ambil gambar dari kamera.');
            return;
        }

        toggleLoading(true, 'Mengunggah & mengekstrak teks...');
        const formData = new FormData();
        formData.append('file', source, source.name || 'capture.jpg');

        try {
            // PERBAIKAN: Panggil endpoint API yang benar
            const response = await fetch(`${API_URL}/1-extract-text`, { method: 'POST', body: formData });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error || 'Terjadi kesalahan pada server AI.');
            
            state.mapel_id = mapelId;
            state.judul = judul;
            state.teks_asli = result.extracted_text;
            document.getElementById('extracted_text_area').value = state.teks_asli;
            
            showStep('verify');
        } catch (error) {
            alert('Gagal Ekstraksi Teks: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    }

    document.getElementById('submit-file-btn').addEventListener('click', () => {
        if (ui.fileInput.files.length > 0) handleSubmission(ui.fileInput.files[0]);
    });
    
    let imageBlob = null;
    document.getElementById('submit-camera-btn').addEventListener('click', () => handleSubmission(imageBlob));

    document.getElementById('camera-tab-btn').addEventListener('shown.bs.tab', async () => {
        try {
            ui.cameraFeed.srcObject = await navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } });
        } catch (err) { alert("Tidak bisa mengakses kamera. Pastikan Anda memberikan izin dan halaman ini diakses via HTTPS atau localhost."); }
    });
    ui.captureBtn.addEventListener('click', () => {
        ui.imageCanvas.width = ui.cameraFeed.videoWidth;
        ui.imageCanvas.height = ui.cameraFeed.videoHeight;
        ui.imageCanvas.getContext('2d').drawImage(ui.cameraFeed, 0, 0);
        ui.imageCanvas.toBlob(blob => {
            imageBlob = blob;
            ui.capturedImage.src = URL.createObjectURL(blob);
            ui.cameraView.classList.add('d-none');
            ui.previewView.classList.remove('d-none');
        }, 'image/jpeg');
    });
    ui.retakeBtn.addEventListener('click', () => {
        imageBlob = null;
        ui.previewView.classList.add('d-none');
        ui.cameraView.classList.remove('d-none');
    });

    document.getElementById('summarize-btn').addEventListener('click', async () => {
        state.teks_asli = document.getElementById('extracted_text_area').value;
        toggleLoading(true, 'Membuat ringkasan...');
        try {
            // PERBAIKAN: Panggil endpoint API yang benar
            const response = await fetch(`${API_URL}/2-summarize-text`, { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ text: state.teks_asli }) });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error);
            state.ringkasan = result.summary;
            document.getElementById('summary_text_area').value = state.ringkasan;
            document.getElementById('summary-container').classList.remove('d-none');
        } catch (error) {
            alert('Gagal membuat ringkasan: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });

    document.getElementById('goto-questions-btn').addEventListener('click', () => {
        state.teks_asli = document.getElementById('extracted_text_area').value;
        if (document.getElementById('summary_text_area').value) state.ringkasan = document.getElementById('summary_text_area').value;
        showStep('questions');
        renderQuestionList();
    });

    document.getElementById('is-essay-checkbox').addEventListener('change', (e) => {
        document.getElementById('manual-distractors-container').classList.toggle('d-none', e.target.checked);
    });

    ui.manualForm.addEventListener('submit', () => {
        const isEssay = document.getElementById('is-essay-checkbox').checked;
        const newQuestion = {
            jenis_soal: isEssay ? 'Esai' : 'Pilihan Ganda',
            pertanyaan: document.getElementById('manual-question').value,
            jawaban_benar: document.getElementById('manual-answer').value,
            distractors: []
        };
        if (!isEssay) {
            document.querySelectorAll('#manual-distractors-container input').forEach(input => {
                if (input.value) newQuestion.distractors.push(input.value);
            });
        }
        state.soal.push(newQuestion);
        renderQuestionList();
        ui.manualForm.reset();
        document.getElementById('manual-distractors-container').classList.remove('d-none');
    });

    document.getElementById('ai-generate-btn').addEventListener('click', async () => {
        const sourceType = document.getElementById('ai-text-source').value;
        const context = (sourceType === 'summary' && state.ringkasan) ? state.ringkasan : state.teks_asli;
        if (!context) { alert('Tidak ada teks sumber untuk membuat soal.'); return; }
        const questionType = document.getElementById('ai-question-type').value;
        toggleLoading(true, `Membuat soal ${questionType.replace('_', ' ')}...`);
        try {
            // PERBAIKAN: Panggil endpoint API yang benar
            const response = await fetch(`${API_URL}/3-generate-questions`, { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ context: context, question_type: questionType, num_questions: 3 }) });
            const result = await response.json();
            if (!response.ok) throw new Error(result.error);
            
            result.questions.forEach(q => {
                state.soal.push({
                    jenis_soal: questionType === 'pilihan_ganda' ? 'Pilihan Ganda' : 'Esai',
                    pertanyaan: q.question,
                    jawaban_benar: q.answer,
                    distractors: q.distractors || []
                });
            });
            renderQuestionList();
        } catch (error) {
            alert('Gagal membuat soal: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });
    
    function renderQuestionList() {
        ui.questionListContainer.innerHTML = '';
        if (state.soal.length === 0) {
            ui.questionListContainer.innerHTML = '<div class="list-group-item text-center text-muted">Belum ada soal yang dibuat.</div>';
            return;
        }
        state.soal.forEach((q, index) => {
            const item = document.createElement('div');
            item.className = 'list-group-item';
            let content = `<div class="d-flex w-100 justify-content-between">
                <h6 class="mb-1">Soal #${index + 1} <span class="badge bg-secondary">${q.jenis_soal === 'Pilihan Ganda' ? 'PG' : 'Esai'}</span></h6>
                <button type="button" class="btn-close btn-sm" onclick="removeQuestion(${index})"></button>
            </div>
            <p class="mb-1 small">${q.pertanyaan}</p>
            <small class="text-success fw-bold">Jawaban: ${q.jawaban_benar}</small>`;
            if (q.jenis_soal === 'Pilihan Ganda' && q.distractors) {
                content += `<div class="text-muted small">Pengecoh: ${q.distractors.join(', ')}</div>`;
            }
            item.innerHTML = content;
            ui.questionListContainer.appendChild(item);
        });
    }
    window.removeQuestion = (index) => {
        state.soal.splice(index, 1);
        renderQuestionList();
    }
    
    document.getElementById('save-all-btn').addEventListener('click', async () => {
        if (state.soal.length === 0) {
            alert('Buat setidaknya satu soal sebelum menyimpan.');
            return;
        }
        toggleLoading(true, 'Menyimpan semua data...');
        try {
            // PERBAIKAN: Panggil endpoint PHP yang benar
            const response = await fetch('<?= BASE_URL ?>/api/save-materi-soal', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(state)
            });
            const result = await response.json();
            if (!response.ok) throw new Error(result.message);
            
            alert(result.message);
            window.location.href = result.redirect_url || '<?= BASE_URL ?>/dashboard-guru';

        } catch (error) {
            alert('Gagal menyimpan: ' + error.message);
        } finally {
            toggleLoading(false);
        }
    });
});
</script>

<?php 
// PERBAIKAN: Gunakan ROOT_PATH untuk path yang andal
require_once ROOT_PATH . '/views/layouts/main_footer.php'; 
?>