<?php 
session_start();
$pageTitle = "Login Siswa";
require_once __DIR__ . '/../layouts/header.php'; 
?>

<div class="col-md-4 col-lg-6 bg-image">
    <div class="quote-wrapper">
        <img src="/assets/images/logo.png" alt="Logo" style="width: 120px; margin-bottom: 20px;">
        <h2 class="mb-3">Sistem Ujian Otomatis</h2>
        <p class="lead">"Pendidikan adalah senjata paling ampuh yang bisa kamu gunakan untuk mengubah dunia."</p>
        <footer class="blockquote-footer text-white-50">Nelson Mandela</footer>
    </div>
</div>

<div class="col-md-8 col-lg-6">
    <div class="login d-flex align-items-center py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-9 col-lg-8 mx-auto">
                    <h3 class="login-heading mb-4">Selamat Datang, Siswa!</h3>
                    <?php
                    if (isset($_SESSION['error_message'])) {
                        echo '<div class="alert alert-danger" role="alert">' . $_SESSION['error_message'] . '</div>';
                        unset($_SESSION['error_message']);
                    }
                    ?>
                    <form action="<?= BASE_URL; ?>/auth/login" method="POST">
                        <input type="hidden" name="role" value="siswa">
                        <div class="form-floating mb-3">
                            <input type="email" class="form-control" id="email" name="email" placeholder="nama@email.com" required>
                            <label for="email">Alamat Email</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                            <label for="password">Password</label>
                        </div>
                        <div class="d-grid">
                            <button class="btn btn-lg btn-primary btn-login text-uppercase fw-bold mb-2" type="submit">Masuk</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>