<?php
require_once __DIR__ . '/../config/Database.php';

class User {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function findByEmailAndRole($email, $role) {
        try {
            $stmt = $this->db->prepare("SELECT * FROM users WHERE email = :email AND role = :role LIMIT 1");
            $stmt->execute(['email' => $email, 'role' => $role]);
            return $stmt->fetch(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            die("Error: " . $e->getMessage());
            return false;
        }
    }
    public function findSiswaByUserId($userId) {
        try {
            $stmt = $this->db->prepare("SELECT * FROM siswa WHERE user_id = :user_id LIMIT 1");
            $stmt->execute(['user_id' => $userId]);
            return $stmt->fetch(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            return false;
        }
    }
}
?>