<?php
// models/UjianGuru.php (REVISI FINAL SESUAI DB)

class UjianGuru {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    public function getApprovedSoalByMapel($mapelId) {
        try {
            $stmt = $this->db->prepare(
                "SELECT soal_id, pertanyaan, jenis_soal 
                 FROM soal 
                 WHERE mapel_id = :mapel_id AND status_validasi = 'Disetujui'
                 ORDER BY jenis_soal, created_at DESC"
            );
            $stmt->execute(['mapel_id' => $mapelId]);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get Approved Soal Error: " . $e->getMessage());
            return [];
        }
    }

    public function saveUjian($judul, $mapelId, $dibuatOleh, $soalIds) {
        $this->db->beginTransaction();
        try {
            $kodeUjian = strtoupper(substr(preg_replace('/[^A-Za-z0-9]/', '', $judul), 0, 4)) . '-' . rand(100, 999);

            $stmtUjian = $this->db->prepare(
                "INSERT INTO ujian (judul_ujian, mapel_id, kode_ujian, dibuat_oleh_user_id) 
                 VALUES (:judul, :mapel_id, :kode, :dibuat_oleh)"
            );
            $stmtUjian->execute([
                'judul' => $judul, 
                'mapel_id' => $mapelId, 
                'kode' => $kodeUjian, 
                'dibuat_oleh' => $dibuatOleh
            ]);
            $ujianId = $this->db->lastInsertId();

            // Disesuaikan: Insert ke tabel 'ujian_soal'
            $stmtDetail = $this->db->prepare(
                "INSERT INTO ujian_soal (ujian_id, soal_id) VALUES (:ujian_id, :soal_id)"
            );
            foreach ($soalIds as $soalId) {
                $stmtDetail->execute(['ujian_id' => $ujianId, 'soal_id' => $soalId]);
            }

            $this->db->commit();
            return $kodeUjian;
        } catch (PDOException $e) {
            $this->db->rollBack();
            error_log("Save Ujian Error: " . $e->getMessage());
            return false;
        }
    }
    
    public function getAllUjianByGuru($guruId) {
        try {
            $stmt = $this->db->prepare(
                "SELECT u.ujian_id, u.judul_ujian, u.kode_ujian, mp.nama_pelajaran, COUNT(us.soal_id) as jumlah_soal
                 FROM ujian u
                 JOIN mata_pelajaran mp ON u.mapel_id = mp.mapel_id
                 LEFT JOIN ujian_soal us ON u.ujian_id = us.ujian_id
                 WHERE u.dibuat_oleh_user_id = :guru_id
                 GROUP BY u.ujian_id
                 ORDER BY u.created_at DESC"
            );
            $stmt->execute(['guru_id' => $guruId]);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get All Ujian by Guru Error: " . $e->getMessage());
            return [];
        }
    }

    public function getHasilByUjian($ujianId) {
        try {
            $stmt = $this->db->prepare(
                "SELECT u.name as nama_siswa, s.kelas, hu.skor_akhir, hu.waktu_selesai as waktu_mengerjakan
                 FROM hasil_ujian hu
                 JOIN siswa s ON hu.siswa_id = s.siswa_id
                 JOIN users u ON s.user_id = u.user_id
                 WHERE hu.ujian_id = :ujian_id
                 ORDER BY u.name ASC"
            );
            $stmt->execute(['ujian_id' => $ujianId]);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get Hasil by Ujian Error: " . $e->getMessage());
            return [];
        }
    }
}
?>