<?php
// models/Soal.php (REVISI FINAL SESUAI DB)

class Soal {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    // Disesuaikan: Logika penyimpanan soal PG dan Esai
    public function save($pertanyaan, $jawabanBenar, $dibuatOleh, $mapelId, $distractors = [], $jenisSoal = 'Esai') {
        $this->db->beginTransaction();
        try {
            // Langkah 1: Simpan data utama ke tabel 'soal'
            $stmt = $this->db->prepare(
                "INSERT INTO soal (pertanyaan, jawaban_benar, dibuat_oleh_user_id, mapel_id, jenis_soal) 
                 VALUES (:pertanyaan, :jawaban_benar, :dibuat_oleh, :mapel_id, :jenis_soal)"
            );
            $stmt->execute([
                'pertanyaan' => $pertanyaan,
                'jawaban_benar' => ($jenisSoal === 'Pilihan Ganda') ? $jawabanBenar : null,
                'dibuat_oleh' => $dibuatOleh,
                'mapel_id' => $mapelId,
                'jenis_soal' => $jenisSoal
            ]);
            $soalId = $this->db->lastInsertId();

            // Langkah 2: Jika Pilihan Ganda, simpan opsi ke tabel 'opsi_soal'
            if ($jenisSoal === 'Pilihan Ganda' && !empty($distractors)) {
                $opsiStmt = $this->db->prepare("INSERT INTO opsi_soal (soal_id, opsi_text, is_correct) VALUES (:soal_id, :opsi_text, :is_correct)");
                
                // Simpan jawaban benar sebagai salah satu opsi
                $opsiStmt->execute(['soal_id' => $soalId, 'opsi_text' => $jawabanBenar, 'is_correct' => 1]);

                // Simpan jawaban pengecoh (distractors)
                foreach ($distractors as $opsi) {
                    $opsiStmt->execute(['soal_id' => $soalId, 'opsi_text' => $opsi, 'is_correct' => 0]);
                }
            } else if ($jenisSoal === 'Esai') {
                // Untuk Esai, simpan kunci jawaban di kolom jawaban_benar
                $updateStmt = $this->db->prepare("UPDATE soal SET jawaban_benar = :jawaban_benar WHERE soal_id = :soal_id");
                $updateStmt->execute(['jawaban_benar' => $jawabanBenar, 'soal_id' => $soalId]);
            }
            
            $this->db->commit();
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            error_log("Save Soal Error: " . $e->getMessage());
            return false;
        }
    }
}
?>