<?php
// models/Materi.php (REVISI FINAL SESUAI DB)

class Materi {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    // Disesuaikan: Menambahkan kolom teks_asli
    public function save($judul, $ringkasan, $teksAsli, $userId, $mapelId) {
        try {
            $stmt = $this->db->prepare(
                "INSERT INTO materi (judul, ringkasan, teks_asli, user_id, mapel_id) 
                 VALUES (:judul, :ringkasan, :teks_asli, :user_id, :mapel_id)"
            );
            $stmt->execute([
                'judul' => $judul,
                'ringkasan' => $ringkasan,
                'teks_asli' => $teksAsli,
                'user_id' => $userId,
                'mapel_id' => $mapelId
            ]);
            return $this->db->lastInsertId();
        } catch (PDOException $e) {
            error_log("Save Materi Error: " . $e->getMessage());
            return false;
        }
    }
}
?>