<?php
require_once __DIR__ . '/../config/Database.php';

class MataPelajaran {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    /**
     * Mengambil semua data mata pelajaran dari database.
     * @return array Daftar mata pelajaran.
     */
    public function getAll() {
        try {
            $stmt = $this->db->prepare("SELECT mapel_id, nama_pelajaran FROM mata_pelajaran ORDER BY nama_pelajaran ASC");
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            die("Error mengambil data mata pelajaran: " . $e->getMessage());
            return [];
        }
    }

    // Tambahkan ini di dalam class MataPelajaran
    public function getById($mapelId) {
        $stmt = $this->db->prepare("SELECT * FROM mata_pelajaran WHERE mapel_id = :mapel_id");
        $stmt->execute(['mapel_id' => $mapelId]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>