<?php
// models/KelolaSoal.php (REVISI FINAL SESUAI DB)

class KelolaSoal {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    // Disesuaikan: Soal dikelompokkan per Mata Pelajaran, bukan Materi
    public function getSoalGroupByMapelByGuru($guruId) {
        try {
            // Ambil daftar mapel yang memiliki soal buatan guru ini
            $mapelStmt = $this->db->prepare(
                "SELECT DISTINCT mp.mapel_id, mp.nama_pelajaran 
                 FROM soal s 
                 JOIN mata_pelajaran mp ON s.mapel_id = mp.mapel_id 
                 WHERE s.dibuat_oleh_user_id = :guru_id 
                 ORDER BY mp.nama_pelajaran"
            );
            $mapelStmt->execute(['guru_id' => $guruId]);
            $mapelList = $mapelStmt->fetchAll(PDO::FETCH_ASSOC);

            // Untuk setiap mapel, ambil soalnya
            $soalStmt = $this->db->prepare(
                "SELECT soal_id, pertanyaan, jenis_soal, status_validasi 
                 FROM soal WHERE mapel_id = :mapel_id AND dibuat_oleh_user_id = :guru_id"
            );
            foreach ($mapelList as $key => $mapel) {
                $soalStmt->execute(['mapel_id' => $mapel['mapel_id'], 'guru_id' => $guruId]);
                $mapelList[$key]['soal'] = $soalStmt->fetchAll(PDO::FETCH_ASSOC);
            }
            return $mapelList;
        } catch (PDOException $e) {
            error_log("Get Soal Group by Mapel Error: " . $e->getMessage());
            return [];
        }
    }
    
    public function updateSoal($soalId, $pertanyaan) {
        try {
            $stmt = $this->db->prepare(
                "UPDATE soal SET pertanyaan = :pertanyaan, status_validasi = 'Pending', catatan_validasi = NULL 
                 WHERE soal_id = :soal_id"
            );
            return $stmt->execute(['pertanyaan' => $pertanyaan, 'soal_id' => $soalId]);
        } catch (PDOException $e) {
            error_log("Update Soal Error: " . $e->getMessage());
            return false;
        }
    }

    public function deleteSoal($soalId) {
        $this->db->beginTransaction();
        try {
            $stmtOpsi = $this->db->prepare("DELETE FROM opsi_soal WHERE soal_id = :soal_id");
            $stmtOpsi->execute(['soal_id' => $soalId]);

            $stmtSoal = $this->db->prepare("DELETE FROM soal WHERE soal_id = :soal_id");
            $stmtSoal->execute(['soal_id' => $soalId]);
            
            $this->db->commit();
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            error_log("Delete Soal Error: " . $e->getMessage());
            return false;
        }
    }
}
?>