<?php
// models/Dashboard.php (REVISI FINAL SESUAI DB)

class Dashboard {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    public function getSummaryCounts($userId) {
        $counts = [
            'total_mapel' => 0,
            'total_materi' => 0,
            'total_soal' => 0
        ];
        try {
            $stmtMapel = $this->db->query("SELECT COUNT(*) FROM mata_pelajaran");
            $counts['total_mapel'] = $stmtMapel->fetchColumn();

            $stmtMateri = $this->db->prepare("SELECT COUNT(*) FROM materi WHERE user_id = :user_id");
            $stmtMateri->execute(['user_id' => $userId]);
            $counts['total_materi'] = $stmtMateri->fetchColumn();

            // Disesuaikan: Menghitung soal berdasarkan user yang membuatnya
            $stmtSoal = $this->db->prepare("SELECT COUNT(*) FROM soal WHERE dibuat_oleh_user_id = :user_id");
            $stmtSoal->execute(['user_id' => $userId]);
            $counts['total_soal'] = $stmtSoal->fetchColumn();
        } catch (PDOException $e) {
            error_log("Dashboard Query Error: " . $e->getMessage());
        }
        return $counts;
    }
}
?>