<?php
// index.php (FINAL - ROUTER UTAMA)

// 1. SETUP DASAR
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';

$pdo = Database::getInstance()->getConnection();
$path = trim($_GET['path'] ?? '', '/');
$method = $_SERVER['REQUEST_METHOD'];

// 2. DAFTAR RUTE LENGKAP
$routes = [
    'GET' => [
        '' => ['ViewController', 'showLoginGuru'],
        'login-guru' => ['ViewController', 'showLoginGuru'],
        'login-siswa' => ['ViewController', 'showLoginSiswa'],
        'login-wakur' => ['ViewController', 'showLoginWakur'],
        'dashboard-guru' => ['ViewController', 'showDashboardGuru'],
        'buat-ujian' => ['ViewController', 'showBuatUjian'],
        'buat-materi-baru' => ['ViewController', 'showBuatMateriBaru'],
        'kelola-soal' => ['ViewController', 'showKelolaSoal'],
        'rekap-ujian' => ['ViewController', 'showRekapUjian'],
        'detail-hasil' => ['ViewController', 'showDetailHasil'],
        'dashboard-siswa' => ['ViewController', 'showDashboardSiswa'],
        'kerjakan-ujian' => ['ViewController', 'showKerjakanUjian'],
        'hasil-ujian' => ['ViewController', 'showHasilUjian'],
        'dashboard-wakur' => ['ViewController', 'showDashboardWakur'],
        'validasi-mapel' => ['ViewController', 'showValidasiMapel'],
        'tinjau-soal' => ['ViewController', 'showTinjauSoal'],
        'laporan' => ['ViewController', 'showLaporan'],
        'capaian-pembelajaran' => ['ViewController', 'showCapaianPembelajaran'],
        'logout' => ['AuthController', 'logout'],
        // Rute API untuk dipanggil via JavaScript
        'api/get-soal-by-mapel' => ['UjianGuruController', 'getSoalByMapel'],
    ],
    'POST' => [
        'auth/login' => ['AuthController', 'login'],
        'ujian/save' => ['UjianGuruController', 'saveUjian'],
        'soal/update' => ['KelolaSoalController', 'update'],
        'soal/delete' => ['KelolaSoalController', 'delete'],
        'wakur/validasi' => ['WakurController', 'prosesValidasiMapel'],
        // Rute API untuk dipanggil via JavaScript
        'api/save-materi-soal' => ['MateriController', 'saveMateriDanSoal'],
        'api/submit-ujian' => ['UjianController', 'submit'],
    ],
];

// 3. PROSES ROUTING
$routeFound = false;
if (isset($routes[$method][$path])) {
    list($controllerName, $methodName) = $routes[$method][$path];
    $controllerFile = __DIR__ . '/controllers/' . $controllerName . '.php';

    if (file_exists($controllerFile)) {
        require_once $controllerFile;
        $reflection = new ReflectionClass($controllerName);
        $constructor = $reflection->getConstructor();
        
        $controller = ($constructor && count($constructor->getParameters()) > 0)
            ? new $controllerName($pdo)
            : new $controllerName();
        
        $controller->$methodName();
        $routeFound = true;
    }
}

// 4. JIKA RUTE TIDAK DITEMUKAN
if (!$routeFound) {
    http_response_code(404);
    echo "<h1>404 Not Found</h1><p>Halaman ('" . htmlspecialchars($path) . "') tidak ditemukan.</p>";
}
?>