<?php
session_start();
require_once __DIR__ . '/../models/Wakur.php';
require_once __DIR__ . '/../config/config.php';

class WakurController {

    public function prosesValidasiMapel() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $mapelId = $_POST['mapel_id'];
            $status = $_POST['status'];
            $catatan = $_POST['catatan_validasi'];

            if (empty($mapelId) || empty($status)) {
                $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Data tidak lengkap.'];
            } else {
                $model = new Wakur();
                if ($model->prosesValidasiMapel($mapelId, $status, $catatan)) {
                    $_SESSION['flash_message'] = ['type' => 'success', 'text' => "Semua soal yang menunggu untuk mata pelajaran ini berhasil diubah statusnya menjadi '$status'."];
                } else {
                    $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Gagal memproses validasi.'];
                }
            }
        }
        // Arahkan kembali ke halaman daftar validasi
        header('Location: ' . BASE_URL . '/views/wakur/validasi_mapel.php');
        exit();
    }
}
?>