<?php
// UjianGuruController.php (FINAL)

require_once __DIR__ . '/../models/UjianGuru.php';

class UjianGuruController {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    public function getSoalByMapel() {
        header('Content-Type: application/json');
        $mapelId = $_GET['mapel_id'] ?? null;
        if (!$mapelId) {
            echo json_encode(['error' => 'ID Mata Pelajaran tidak ditemukan.']);
            return;
        }
        $model = new UjianGuru($this->db);
        $soal = $model->getApprovedSoalByMapel($mapelId);
        echo json_encode($soal);
    }

    public function saveUjian() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $judul = $_POST['judul_ujian'];
            $mapelId = $_POST['mapel_id'];
            $soalIds = $_POST['soal_ids'] ?? [];

            if (empty($judul) || empty($mapelId) || empty($soalIds)) {
                $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Semua kolom harus diisi dan minimal satu soal dipilih.'];
                // PERBAIKAN: Redirect ke RUTE buat-ujian.
                header('Location: ' . BASE_URL . '/buat-ujian');
                exit();
            }

            $model = new UjianGuru($this->db);
            $kodeUjian = $model->saveUjian($judul, $mapelId, $soalIds);

            if ($kodeUjian) {
                $_SESSION['flash_message'] = ['type' => 'success', 'text' => "Ujian berhasil dibuat dengan kode: <strong>$kodeUjian</strong>"];
            } else {
                $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Gagal membuat ujian. Terjadi kesalahan pada database.'];
            }
            // PERBAIKAN: Redirect ke RUTE dashboard.
            header('Location: ' . BASE_URL . '/dashboard-guru');
            exit();
        }
    }
}