<?php
// UjianController.php (FINAL)

require_once __DIR__ . '/../models/UjianSiswa.php';

class UjianController {
    private $db;
    
    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    public function submit() {
        header('Content-Type: application/json');
        $response = [];
        try {
            $data = json_decode(file_get_contents('php://input'), true);

            if (!isset($data['ujian_id'], $data['siswa_id'], $data['answers'])) {
                throw new Exception("Data jawaban tidak lengkap.");
            }

            $ujianModel = new UjianSiswa($this->db);
            $hasilId = $ujianModel->submitAndCalculateScore($data['ujian_id'], $data['siswa_id'], $data['answers']);

            if (!$hasilId) {
                throw new Exception("Gagal menyimpan hasil ujian ke database.");
            }
            
            $response['status'] = 'success';
            $response['message'] = 'Jawaban berhasil disimpan!';
            // PERBAIKAN: Redirect URL ke RUTE hasil-ujian.
            $response['redirect_url'] = BASE_URL . '/hasil-ujian?hasil_id=' . $hasilId;

        } catch (Exception $e) {
            http_response_code(500);
            $response['status'] = 'error';
            $response['message'] = $e->getMessage();
        }
        
        echo json_encode($response);
        exit();
    }
}