<?php
session_start();
require_once __DIR__ . '/../models/Materi.php';
require_once __DIR__ . '/../models/Soal.php';
require_once __DIR__ . '/../config/config.php';

class MateriController {

    // Helper function to call Flask API
    private function callApi($url, $data, $isJson = false) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        if ($isJson) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        } else {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            $error = 'cURL Error: ' . curl_error($ch);
            curl_close($ch);
            // Return error as JSON
            http_response_code(500);
            echo json_encode(['error' => $error]);
            exit();
        }
        curl_close($ch);
        return $response;
    }
    
    // ACTION 1: Menerima file, memanggil API, dan mengembalikan ringkasan
    public function processAndSummarize() {
        header('Content-Type: application/json');
        if (!isset($_FILES['file_materi']) || $_FILES['file_materi']['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['error' => 'File gagal diunggah.']);
            exit();
        }
        $file = $_FILES['file_materi'];
        $cfile = new CURLFile($file['tmp_name'], $file['type'], $file['name']);
        
        // Pass the response from Flask API directly to the frontend
        echo $this->callApi(FLASK_API_URL . '/process_and_summarize', ['file' => $cfile]);
    }

    // ACTION 2: Menerima ringkasan, memanggil API, dan mengembalikan soal
    public function generateQuestions() {
        header('Content-Type: application/json');
        $data = json_decode(file_get_contents('php://input'), true);

        // Pass the response from Flask API directly to the frontend
        echo $this->callApi(FLASK_API_URL . '/generate_questions', $data, true);
    }
    
    // ACTION 3: Menerima data lengkap dan menyimpannya ke database
    public function saveMateriDanSoal() {
        header('Content-Type: application/json');
        $response = [];
        try {
            $data = json_decode(file_get_contents('php://input'), true);

            if (!isset($data['judul'], $data['mapel_id'], $data['ringkasan'], $data['soal'])) {
                throw new Exception("Data yang diterima tidak lengkap.");
            }
            $userId = $_SESSION['user_id'];

            $materiModel = new Materi();
            $materiId = $materiModel->save($data['judul'], $data['ringkasan'], $userId, $data['mapel_id']);
            if (!$materiId) {
                throw new Exception("Gagal menyimpan materi ke database.");
            }
            
            if (!empty($data['soal'])) {
                $soalModel = new Soal();
                foreach ($data['soal'] as $q) {
                    $soalModel->save(
                        $q['question'], 
                        $q['answer'], 
                        $materiId, 
                        $data['mapel_id'],
                        isset($q['distractors']) ? 'Pilihan Ganda' : 'Esai'
                    );
                }
            }
            $response['status'] = 'success';
            $response['message'] = 'Materi dan soal berhasil disimpan di bank soal!';
            $response['redirect_url'] = BASE_URL . '/views/guru/dashboard.php';
        } catch (Exception $e) {
            http_response_code(500);
            $response['status'] = 'error';
            $response['message'] = $e->getMessage();
        }
        
        echo json_encode($response);
        exit();
    }
}
?>