<?php
// KelolaSoalController.php (FINAL)

require_once __DIR__ . '/../models/KelolaSoal.php';

class KelolaSoalController {
    private $db;

    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }
    
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $soalId = $_POST['soal_id'];
            $pertanyaan = $_POST['pertanyaan'];

            $model = new KelolaSoal($this->db);
            if ($model->updateSoal($soalId, $pertanyaan)) {
                $_SESSION['flash_message'] = ['type' => 'success', 'text' => 'Soal berhasil diperbarui dan dikembalikan ke status "Pending".'];
            } else {
                $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Gagal memperbarui soal.'];
            }
        }
        // PERBAIKAN: Redirect ke RUTE kelola-soal.
        header('Location: ' . BASE_URL . '/kelola-soal');
        exit();
    }

    public function delete() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $soalId = $_POST['soal_id'];
            
            $model = new KelolaSoal($this->db);
            if ($model->deleteSoal($soalId)) {
                $_SESSION['flash_message'] = ['type' => 'success', 'text' => 'Soal berhasil dihapus.'];
            } else {
                $_SESSION['flash_message'] = ['type' => 'danger', 'text' => 'Gagal menghapus soal.'];
            }
        }
        // PERBAIKAN: Redirect ke RUTE kelola-soal.
        header('Location: ' . BASE_URL . '/kelola-soal');
        exit();
    }
}