<?php
// AuthController.php (FINAL)

// Memuat model yang diperlukan
require_once __DIR__ . '/../models/User.php';

class AuthController {
    private $db;

    // Menerima koneksi database PDO dari router (index.php)
    public function __construct($pdoConnection) {
        $this->db = $pdoConnection;
    }

    public function login() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            http_response_code(405);
            exit("Method Not Allowed");
        }

        $email = $_POST['email'];
        $password = $_POST['password'];
        $role = $_POST['role'];

        $userModel = new User($this->db);
        $user = $userModel->findByEmailAndRole($email, $role);

        // PENTING: Gunakan password_verify() di aplikasi produksi.
        if ($user && $password === $user['password']) {
            $_SESSION['user_id'] = $user['user_id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];
            $this->redirectToDashboard($user['role']);
        } else {
            $_SESSION['error_message'] = "Email atau Password salah!";
            // PERBAIKAN: Redirect ke RUTE login, bukan file.
            $role_path = str_replace(' ', '-', $role);
            header('Location: ' . BASE_URL . '/login-' . $role_path);
            exit();
        }
    }

    public function logout() {
        session_unset();
        session_destroy();
        // PERBAIKAN: Redirect ke RUTE login default.
        header('Location: ' . BASE_URL . '/login-guru');
        exit();
    }

    private function redirectToDashboard($role) {
        $dashboardPath = '';
        switch ($role) {
            case 'guru':
                $dashboardPath = '/dashboard-guru';
                break;
            case 'siswa':
                $dashboardPath = '/dashboard-siswa';
                break;
            case 'wakil kurikulum':
                $dashboardPath = '/dashboard-wakur';
                break;
            default:
                $dashboardPath = '/login-guru';
                break;
        }
        // PERBAIKAN: Redirect ke RUTE dashboard yang sesuai.
        header('Location: ' . BASE_URL . $dashboardPath);
        exit();
    }
}