<?php
// database.php (REVISI FINAL)

// PERBAIKAN: Menggunakan __DIR__ untuk path yang absolut dan andal
require_once __DIR__ . '/config.php';

class Database {
    private static $instance = null;
    private $conn;

    private function __construct() {
        try {
            // Cek apakah ini lingkungan Google Cloud atau bukan
            if (defined('INSTANCE_CONNECTION_NAME') && !empty(INSTANCE_CONNECTION_NAME)) {
                // Koneksi untuk Google Cloud SQL
                $dsn = sprintf(
                    'mysql:dbname=%s;unix_socket=/cloudsql/%s',
                    DB_NAME,
                    INSTANCE_CONNECTION_NAME
                );
            } else {
                // Koneksi untuk lingkungan lokal (localhost)
                $dsn = sprintf(
                    'mysql:host=%s;dbname=%s;charset=%s',
                    DB_HOST,
                    DB_NAME,
                    DB_CHARSET
                );
            }
            
            // Opsi PDO untuk koneksi yang lebih baik
            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
            ];

            // Buat koneksi PDO
            $this->conn = new PDO($dsn, DB_USER, DB_PASS, $options);

        } catch (PDOException $e) {
            // Tampilkan pesan error yang lebih umum dan aman
            die("Koneksi ke database gagal: " . $e->getMessage());
        }
    }

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->conn;
    }
}